/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.library.plugins.debug;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IClickableIngredientFactory;
import mezz.jei.api.gui.handlers.IGuiContainerHandler;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.helpers.IPlatformFluidHelper;
import mezz.jei.api.ingredients.IIngredientTypeWithSubtypes;
import mezz.jei.api.registration.IAdvancedRegistration;
import mezz.jei.api.registration.IExtraIngredientRegistration;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IIngredientAliasRegistration;
import mezz.jei.api.registration.IModInfoRegistration;
import mezz.jei.api.registration.IModIngredientRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import mezz.jei.api.runtime.IClickableIngredient;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.api.runtime.IJeiRuntime;
import mezz.jei.common.Internal;
import mezz.jei.common.config.DebugConfig;
import mezz.jei.common.gui.textures.Textures;
import mezz.jei.common.platform.IPlatformFluidHelperInternal;
import mezz.jei.common.platform.IPlatformScreenHelper;
import mezz.jei.common.platform.Services;
import mezz.jei.common.util.ErrorUtil;
import mezz.jei.common.util.MathUtil;
import mezz.jei.common.util.RegistryUtil;
import mezz.jei.library.plugins.debug.DebugCategoryDecorator;
import mezz.jei.library.plugins.debug.DebugFocusRecipeCategory;
import mezz.jei.library.plugins.debug.DebugGhostIngredientHandler;
import mezz.jei.library.plugins.debug.DebugGhostIngredientHandlerTwo;
import mezz.jei.library.plugins.debug.DebugRecipe;
import mezz.jei.library.plugins.debug.DebugRecipeCategory;
import mezz.jei.library.plugins.debug.DebugSimpleRecipeManagerPlugin;
import mezz.jei.library.plugins.debug.FluidSubtypeHandlerTest;
import mezz.jei.library.plugins.debug.ObnoxiouslyLargeCategory;
import mezz.jei.library.plugins.debug.ObnoxiouslyLargeRecipe;
import mezz.jei.library.plugins.debug.ingredients.DebugIngredient;
import mezz.jei.library.plugins.debug.ingredients.DebugIngredientHelper;
import mezz.jei.library.plugins.debug.ingredients.DebugIngredientListFactory;
import mezz.jei.library.plugins.debug.ingredients.DebugIngredientRenderer;
import mezz.jei.library.plugins.debug.ingredients.ErrorIngredient;
import mezz.jei.library.plugins.debug.ingredients.ErrorIngredientHelper;
import mezz.jei.library.plugins.debug.ingredients.ErrorIngredientListFactory;
import mezz.jei.library.plugins.debug.ingredients.ErrorIngredientRenderer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.BrewingStandScreen;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.SmithingTransformRecipe;
import net.minecraft.world.item.crafting.TransmuteResult;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.Nullable;

@JeiPlugin
public class JeiDebugPlugin
implements IModPlugin {
    @Nullable
    private DebugRecipeCategory<?> debugRecipeCategory;

    @Override
    public ResourceLocation getPluginUid() {
        return ResourceLocation.fromNamespaceAndPath((String)"jei", (String)"debug");
    }

    @Override
    public void registerIngredients(IModIngredientRegistration registration) {
        if (DebugConfig.isDebugModeEnabled()) {
            DebugIngredientHelper ingredientHelper = new DebugIngredientHelper();
            DebugIngredientRenderer ingredientRenderer = new DebugIngredientRenderer(ingredientHelper);
            registration.register(DebugIngredient.TYPE, Collections.emptyList(), ingredientHelper, ingredientRenderer, DebugIngredient.CODEC);
            if (DebugConfig.isCrashingTestIngredientsEnabled()) {
                ErrorIngredientHelper errorIngredientHelper = new ErrorIngredientHelper();
                ErrorIngredientRenderer errorIngredientRenderer = new ErrorIngredientRenderer(errorIngredientHelper);
                Collection<ErrorIngredient> errorIngredients = ErrorIngredientListFactory.create();
                registration.register(ErrorIngredient.TYPE, errorIngredients, errorIngredientHelper, errorIngredientRenderer, ErrorIngredient.CODEC);
            }
        }
    }

    @Override
    public void registerExtraIngredients(IExtraIngredientRegistration registration) {
        if (DebugConfig.isDebugModeEnabled()) {
            registration.addExtraIngredients(DebugIngredient.TYPE, DebugIngredientListFactory.create(0, 10));
        }
    }

    @Override
    public void registerIngredientAliases(IIngredientAliasRegistration registration) {
        registration.addAlias(new ItemStack((ItemLike)Items.PANDA_SPAWN_EGG), "jei.alias.panda.spawn.egg");
        registration.addAlias(new ItemStack((ItemLike)Items.VILLAGER_SPAWN_EGG), "jei.alias.villager.spawn.egg");
        registration.addAliases(VanillaTypes.ITEM_STACK, List.of(new ItemStack((ItemLike)Items.STRUCTURE_VOID), new ItemStack((ItemLike)Items.BARRIER)), "nothing");
        registration.addAliases(VanillaTypes.ITEM_STACK, List.of(new ItemStack((ItemLike)Items.GOLDEN_HOE), new ItemStack((ItemLike)Items.DIAMOND_BLOCK)), (Collection<String>)List.of("shiny", "valuable", "Expensive", "expansive", "extensive"));
        IPlatformFluidHelperInternal<?> fluidHelper = Services.PLATFORM.getFluidHelper();
        this.registerFluidAliases(registration, fluidHelper);
    }

    private <T> void registerFluidAliases(IIngredientAliasRegistration registration, IPlatformFluidHelper<T> fluidHelper) {
        Holder.Reference water = Fluids.WATER.builtInRegistryHolder();
        registration.addAliases(fluidHelper.getFluidIngredientType(), fluidHelper.create((Holder<Fluid>)water, fluidHelper.bucketVolume()), List.of("wet", "aqua", "sea", "ocean"));
    }

    @Override
    public void registerModInfo(IModInfoRegistration registration) {
        registration.addModAliases("jei", "jei");
    }

    @Override
    public void registerCategories(IRecipeCategoryRegistration registration) {
        if (DebugConfig.isDebugModeEnabled()) {
            IJeiHelpers jeiHelpers = registration.getJeiHelpers();
            IGuiHelper guiHelper = jeiHelpers.getGuiHelper();
            IPlatformFluidHelper<?> platformFluidHelper = jeiHelpers.getPlatformFluidHelper();
            IIngredientManager ingredientManager = jeiHelpers.getIngredientManager();
            Textures textures = Internal.getTextures();
            this.debugRecipeCategory = new DebugRecipeCategory(guiHelper, platformFluidHelper, ingredientManager);
            registration.addRecipeCategories(this.debugRecipeCategory, new DebugFocusRecipeCategory(platformFluidHelper), new ObnoxiouslyLargeCategory(guiHelper, textures, ingredientManager));
        }
    }

    @Override
    public void registerRecipes(IRecipeRegistration registration) {
        if (DebugConfig.isDebugModeEnabled()) {
            registration.addItemStackInfo(List.of(new ItemStack((ItemLike)Blocks.OAK_DOOR), new ItemStack((ItemLike)Blocks.SPRUCE_DOOR), new ItemStack((ItemLike)Blocks.BIRCH_DOOR), new ItemStack((ItemLike)Blocks.JUNGLE_DOOR), new ItemStack((ItemLike)Blocks.ACACIA_DOOR), new ItemStack((ItemLike)Blocks.DARK_OAK_DOOR)), new Component[]{Component.translatable((String)"description.jei.wooden.door.1"), Component.translatable((String)"description.jei.wooden.door.2"), Component.translatable((String)"description.jei.wooden.door.3")});
            IJeiHelpers jeiHelpers = registration.getJeiHelpers();
            IPlatformFluidHelper<?> platformFluidHelper = jeiHelpers.getPlatformFluidHelper();
            this.registerFluidRecipes(registration, platformFluidHelper);
            registration.addIngredientInfo(new DebugIngredient(1), DebugIngredient.TYPE, new Component[]{Component.literal((String)"debug")});
            registration.addIngredientInfo(new DebugIngredient(2), DebugIngredient.TYPE, new Component[]{Component.literal((String)"debug colored").withStyle(ChatFormatting.AQUA), Component.literal((String)"debug\\nSplit and colored").withStyle(ChatFormatting.LIGHT_PURPLE), Component.translatable((String)"description.jei.debug.formatting.1", (Object[])new Object[]{"various"}), Component.translatable((String)"description.jei.debug.formatting.1", (Object[])new Object[]{"various\\nsplit"}), Component.translatable((String)"description.jei.debug.formatting.1", (Object[])new Object[]{Component.literal((String)"various colored").withStyle(ChatFormatting.RED)}), Component.translatable((String)"description.jei.debug.formatting.1", (Object[])new Object[]{Component.literal((String)"various\\nsplit colored").withStyle(ChatFormatting.DARK_AQUA)}), Component.translatable((String)"description.jei.debug.formatting.1", (Object[])new Object[]{"\\nSplitting at the start"}), Component.translatable((String)"description.jei.debug.formatting.1", (Object[])new Object[]{"various all colored"}).withStyle(ChatFormatting.RED), Component.translatable((String)"description.jei.debug.formatting.1", (Object[])new Object[]{Component.translatable((String)"description.jei.debug.formatting.3", (Object[])new Object[]{"various"}).withStyle(ChatFormatting.DARK_AQUA)}), Component.translatable((String)"description.jei.debug.formatting.2", (Object[])new Object[]{Component.literal((String)"multiple").withStyle(ChatFormatting.GOLD).withStyle(ChatFormatting.ITALIC), Component.literal((String)"various").withStyle(ChatFormatting.RED)}).withStyle(ChatFormatting.BLUE), Component.translatable((String)"description.jei.debug.formatting.1", (Object[])new Object[]{Component.translatable((String)"description.jei.debug.formatting.3", (Object[])new Object[]{Component.translatable((String)"description.jei.debug.formatting.2", (Object[])new Object[]{Component.literal((String)"multiple").withStyle(ChatFormatting.GOLD).withStyle(ChatFormatting.ITALIC), Component.literal((String)"various").withStyle(ChatFormatting.RED)}).withStyle(ChatFormatting.DARK_AQUA)})})});
            registration.addRecipes(DebugRecipeCategory.TYPE, List.of(new DebugRecipe(), new DebugRecipe()));
            registration.addRecipes(DebugFocusRecipeCategory.TYPE, List.of(new DebugRecipe()));
            ResourceLocation testRecipeWithoutTemplateId = ResourceLocation.fromNamespaceAndPath((String)"jei", (String)"test_recipe_without_template");
            RecipeHolder testRecipeWithoutTemplate = new RecipeHolder(ResourceKey.create((ResourceKey)Registries.RECIPE, (ResourceLocation)testRecipeWithoutTemplateId), (Recipe)new SmithingTransformRecipe(Optional.empty(), Ingredient.of((ItemLike)Items.APPLE), Optional.of(Ingredient.of((ItemLike)Items.BAKED_POTATO)), new TransmuteResult(Items.ACACIA_BOAT)));
            registration.addRecipes(RecipeTypes.SMITHING, List.of(testRecipeWithoutTemplate));
            registration.addRecipes(ObnoxiouslyLargeCategory.TYPE, List.of(new ObnoxiouslyLargeRecipe()));
        }
    }

    private <T> void registerFluidRecipes(IRecipeRegistration registration, IPlatformFluidHelper<T> platformFluidHelper) {
        long bucketVolume = platformFluidHelper.bucketVolume();
        T fluidIngredient = platformFluidHelper.create((Holder<Fluid>)Fluids.WATER.defaultFluidState().holder(), bucketVolume);
        registration.addIngredientInfo(fluidIngredient, platformFluidHelper.getFluidIngredientType(), new Component[]{Component.literal((String)"water")});
        fluidIngredient = platformFluidHelper.create((Holder<Fluid>)Fluids.LAVA.defaultFluidState().holder(), 1L);
        registration.addIngredientInfo(fluidIngredient, platformFluidHelper.getFluidIngredientType(), new Component[]{Component.literal((String)"small amount of lava that should still show as 1 bucket")});
    }

    @Override
    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        if (DebugConfig.isDebugModeEnabled()) {
            IJeiHelpers jeiHelpers = registration.getJeiHelpers();
            IIngredientManager ingredientManager = jeiHelpers.getIngredientManager();
            registration.addGuiContainerHandler(BrewingStandScreen.class, new IGuiContainerHandler<BrewingStandScreen>(this){

                @Override
                public List<Rect2i> getGuiExtraAreas(BrewingStandScreen containerScreen) {
                    int widthMovement = (int)(System.currentTimeMillis() / 100L % 100L);
                    int size = 25 + widthMovement;
                    IPlatformScreenHelper screenHelper = Services.PLATFORM.getScreenHelper();
                    int guiLeft = screenHelper.getGuiLeft((AbstractContainerScreen<?>)containerScreen);
                    int xSize = screenHelper.getXSize((AbstractContainerScreen<?>)containerScreen);
                    int guiTop = screenHelper.getGuiTop((AbstractContainerScreen<?>)containerScreen);
                    return List.of(new Rect2i(guiLeft + xSize, guiTop + 40, size, size));
                }

                @Override
                public Optional<? extends IClickableIngredient<?>> getClickableIngredientUnderMouse(IClickableIngredientFactory factory, BrewingStandScreen containerScreen, double mouseX, double mouseY) {
                    Rect2i area = new Rect2i(0, 0, 10, 10);
                    if (MathUtil.contains(area, mouseX, mouseY)) {
                        return factory.createBuilder(new ItemStack((ItemLike)Items.BOW)).buildWithArea(area);
                    }
                    return Optional.empty();
                }
            });
            registration.addGhostIngredientHandler(BrewingStandScreen.class, new DebugGhostIngredientHandler(ingredientManager));
            registration.addGhostIngredientHandler(BrewingStandScreen.class, new DebugGhostIngredientHandlerTwo(ingredientManager));
        }
    }

    @Override
    public <T> void registerFluidSubtypes(ISubtypeRegistration registration, IPlatformFluidHelper<T> platformFluidHelper) {
        FlowingFluid water = Fluids.WATER;
        IIngredientTypeWithSubtypes<Fluid, T> ingredientType = platformFluidHelper.getFluidIngredientType();
        FluidSubtypeHandlerTest<T> subtype = new FluidSubtypeHandlerTest<T>(ingredientType);
        registration.registerSubtypeInterpreter(ingredientType, water, subtype);
    }

    @Override
    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        if (DebugConfig.isDebugModeEnabled()) {
            IPlatformFluidHelperInternal<?> fluidHelper = Services.PLATFORM.getFluidHelper();
            this.registerRecipeCatalysts(registration, fluidHelper);
        }
    }

    private <T> void registerRecipeCatalysts(IRecipeCatalystRegistration registration, IPlatformFluidHelper<T> fluidHelper) {
        long bucketVolume = fluidHelper.bucketVolume();
        registration.addCraftingStation(DebugRecipeCategory.TYPE, DebugIngredient.TYPE, new DebugIngredient(7));
        registration.addCraftingStation(DebugRecipeCategory.TYPE, fluidHelper.getFluidIngredientType(), fluidHelper.create((Holder<Fluid>)Fluids.WATER.defaultFluidState().holder(), bucketVolume));
        registration.addCraftingStation(DebugRecipeCategory.TYPE, new ItemLike[]{Items.STICK});
        RegistryUtil.getRegistry(Registries.ITEM).stream().limit(300L).forEach(item -> {
            ItemStack catalystIngredient = new ItemStack((ItemLike)item);
            if (!catalystIngredient.isEmpty()) {
                registration.addCraftingStation(DebugRecipeCategory.TYPE, catalystIngredient);
            }
        });
    }

    @Override
    public void registerAdvanced(IAdvancedRegistration registration) {
        if (DebugConfig.isDebugModeEnabled()) {
            IJeiHelpers jeiHelpers = registration.getJeiHelpers();
            jeiHelpers.getAllRecipeTypes().filter(r -> r.getUid().getNamespace().equals("jei")).forEach(r -> registration.addRecipeCategoryDecorator(r, DebugCategoryDecorator.getInstance()));
            registration.addSimpleRecipeManagerPlugin(RecipeTypes.CRAFTING, new DebugSimpleRecipeManagerPlugin(jeiHelpers));
        }
    }

    @Override
    public void onRuntimeAvailable(IJeiRuntime jeiRuntime) {
        if (DebugConfig.isDebugModeEnabled()) {
            ErrorUtil.assertMainThread();
            Registry registry = RegistryUtil.getRegistry(Registries.ENCHANTMENT);
            Optional enchantment = registry.get(Enchantments.FIRE_ASPECT);
            assert (enchantment.isPresent());
            if (this.debugRecipeCategory != null) {
                this.debugRecipeCategory.setRuntime(jeiRuntime);
            }
            IIngredientManager ingredientManager = jeiRuntime.getIngredientManager();
            ingredientManager.addIngredientsAtRuntime(DebugIngredient.TYPE, DebugIngredientListFactory.create(10, 20));
        }
    }
}

