/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.common.gui.elements;

import com.mojang.blaze3d.vertex.VertexConsumer;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.common.Constants;
import mezz.jei.common.gui.textures.JeiSpriteUploader;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import org.joml.Matrix4f;

public class DrawableSprite
implements IDrawableStatic {
    private final JeiSpriteUploader spriteUploader;
    private final ResourceLocation location;
    private final int width;
    private final int height;
    private int trimLeft;
    private int trimRight;
    private int trimTop;
    private int trimBottom;

    public DrawableSprite(JeiSpriteUploader spriteUploader, ResourceLocation location, int width, int height) {
        this.spriteUploader = spriteUploader;
        this.location = location;
        this.width = width;
        this.height = height;
    }

    public DrawableSprite trim(int left, int right, int top, int bottom) {
        this.trimLeft = left;
        this.trimRight = right;
        this.trimTop = top;
        this.trimBottom = bottom;
        return this;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public void draw(GuiGraphics guiGraphics, int xOffset, int yOffset) {
        this.draw(guiGraphics, xOffset, yOffset, 0, 0, 0, 0);
    }

    @Override
    public void draw(GuiGraphics guiGraphics, int xOffset, int yOffset, int maskTop, int maskBottom, int maskLeft, int maskRight) {
        TextureAtlasSprite sprite = this.spriteUploader.getSprite(this.location);
        int textureWidth = this.width;
        int textureHeight = this.height;
        RenderType rendertype = RenderType.guiTextured((ResourceLocation)Constants.LOCATION_JEI_GUI_TEXTURE_ATLAS);
        VertexConsumer bufferBuilder = Minecraft.getInstance().renderBuffers().bufferSource().getBuffer(rendertype);
        int x = xOffset + (maskLeft += this.trimLeft);
        int y = yOffset + (maskTop += this.trimTop);
        int width = textureWidth - (maskRight += this.trimRight) - maskLeft;
        int height = textureHeight - (maskBottom += this.trimBottom) - maskTop;
        float uSize = sprite.getU1() - sprite.getU0();
        float vSize = sprite.getV1() - sprite.getV0();
        float minU = sprite.getU0() + uSize * ((float)maskLeft / (float)textureWidth);
        float minV = sprite.getV0() + vSize * ((float)maskTop / (float)textureHeight);
        float maxU = sprite.getU1() - uSize * ((float)maskRight / (float)textureWidth);
        float maxV = sprite.getV1() - vSize * ((float)maskBottom / (float)textureHeight);
        Matrix4f matrix = guiGraphics.pose().last().pose();
        bufferBuilder.addVertex(matrix, (float)x, (float)(y + height), 0.0f).setColor(255, 255, 255, 255).setUv(minU, maxV);
        bufferBuilder.addVertex(matrix, (float)(x + width), (float)(y + height), 0.0f).setColor(255, 255, 255, 255).setUv(maxU, maxV);
        bufferBuilder.addVertex(matrix, (float)(x + width), (float)y, 0.0f).setColor(255, 255, 255, 255).setUv(maxU, minV);
        bufferBuilder.addVertex(matrix, (float)x, (float)y, 0.0f).setColor(255, 255, 255, 255).setUv(minU, minV);
    }
}

