/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.library.plugins.vanilla.anvil;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Objects;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.recipe.vanilla.IJeiAnvilRecipe;
import mezz.jei.api.recipe.vanilla.IVanillaRecipeFactory;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.common.platform.IPlatformItemStackHelper;
import mezz.jei.common.platform.Services;
import mezz.jei.common.util.ErrorUtil;
import mezz.jei.common.util.RegistryUtil;
import mezz.jei.library.plugins.vanilla.anvil.AnvilRecipe;
import mezz.jei.library.plugins.vanilla.ingredients.subtypes.EnchantedBookSubtypeInterpreter;
import mezz.jei.library.util.ResourceLocationUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.context.ContextMap;
import net.minecraft.world.entity.EntityEquipment;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AnvilMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.display.SlotDisplay;
import net.minecraft.world.item.crafting.display.SlotDisplayContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class AnvilRecipeMaker {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final ItemStack ENCHANTED_BOOK = new ItemStack((ItemLike)Items.ENCHANTED_BOOK);

    private AnvilRecipeMaker() {
    }

    public static List<IJeiAnvilRecipe> getAnvilRecipes(IVanillaRecipeFactory vanillaRecipeFactory, IIngredientManager ingredientManager) {
        IIngredientHelper<ItemStack> ingredientHelper = ingredientManager.getIngredientHelper(VanillaTypes.ITEM_STACK);
        return Stream.concat(AnvilRecipeMaker.getRepairRecipes(vanillaRecipeFactory, ingredientHelper), AnvilRecipeMaker.getBookEnchantmentRecipes(ingredientManager)).toList();
    }

    private static Stream<IJeiAnvilRecipe> getBookEnchantmentRecipes(IIngredientManager ingredientManager) {
        Registry registry = RegistryUtil.getRegistry(Registries.ENCHANTMENT);
        List<EnchantmentData> enchantmentDatas = registry.listElements().map(EnchantmentData::new).toList();
        return ingredientManager.getAllItemStacks().stream().filter(ItemStack::isEnchantable).flatMap(ingredient -> AnvilRecipeMaker.getBookEnchantmentRecipes(enchantmentDatas, ingredient));
    }

    private static Stream<IJeiAnvilRecipe> getBookEnchantmentRecipes(List<EnchantmentData> enchantmentDatas, ItemStack ingredient) {
        List<ItemStack> ingredientSingletonList = List.of(ingredient);
        return enchantmentDatas.stream().filter(data -> data.canEnchant(ingredient)).map(data -> data.getEnchantedBooks(ingredient)).filter(enchantedBooks -> !enchantedBooks.isEmpty()).map(enchantedBooks -> {
            List<ItemStack> outputs = AnvilRecipeMaker.getEnchantedIngredients(ingredient, enchantedBooks);
            return new AnvilRecipe(ingredientSingletonList, (List<ItemStack>)enchantedBooks, outputs, null);
        });
    }

    private static List<ItemStack> getEnchantedIngredients(ItemStack ingredient, List<ItemStack> enchantedBooks) {
        return Lists.transform(enchantedBooks, enchantedBook -> AnvilRecipeMaker.getEnchantedIngredient(ingredient, enchantedBook));
    }

    private static ItemStack getEnchantedIngredient(ItemStack ingredient, ItemStack enchantedBook) {
        ItemStack enchantedIngredient = ingredient.copy();
        ItemEnchantments enchantments = EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)enchantedBook);
        EnchantmentHelper.setEnchantments((ItemStack)enchantedIngredient, (ItemEnchantments)enchantments);
        return enchantedIngredient;
    }

    private static Stream<RepairData> getRepairData() {
        return Stream.of(new RepairData((TagKey<Item>)ItemTags.WOODEN_TOOL_MATERIALS, new ItemStack((ItemLike)Items.WOODEN_SWORD), new ItemStack((ItemLike)Items.WOODEN_PICKAXE), new ItemStack((ItemLike)Items.WOODEN_AXE), new ItemStack((ItemLike)Items.WOODEN_SHOVEL), new ItemStack((ItemLike)Items.WOODEN_HOE)), new RepairData((TagKey<Item>)ItemTags.PLANKS, new ItemStack((ItemLike)Items.SHIELD)), new RepairData((TagKey<Item>)ItemTags.STONE_TOOL_MATERIALS, new ItemStack((ItemLike)Items.STONE_SWORD), new ItemStack((ItemLike)Items.STONE_PICKAXE), new ItemStack((ItemLike)Items.STONE_AXE), new ItemStack((ItemLike)Items.STONE_SHOVEL), new ItemStack((ItemLike)Items.STONE_HOE)), new RepairData((TagKey<Item>)ItemTags.REPAIRS_LEATHER_ARMOR, new ItemStack((ItemLike)Items.LEATHER_HELMET), new ItemStack((ItemLike)Items.LEATHER_CHESTPLATE), new ItemStack((ItemLike)Items.LEATHER_LEGGINGS), new ItemStack((ItemLike)Items.LEATHER_BOOTS)), new RepairData((TagKey<Item>)ItemTags.IRON_TOOL_MATERIALS, new ItemStack((ItemLike)Items.IRON_SWORD), new ItemStack((ItemLike)Items.IRON_PICKAXE), new ItemStack((ItemLike)Items.IRON_AXE), new ItemStack((ItemLike)Items.IRON_SHOVEL), new ItemStack((ItemLike)Items.IRON_HOE)), new RepairData((TagKey<Item>)ItemTags.REPAIRS_IRON_ARMOR, new ItemStack((ItemLike)Items.IRON_HELMET), new ItemStack((ItemLike)Items.IRON_CHESTPLATE), new ItemStack((ItemLike)Items.IRON_LEGGINGS), new ItemStack((ItemLike)Items.IRON_BOOTS)), new RepairData((TagKey<Item>)ItemTags.REPAIRS_CHAIN_ARMOR, new ItemStack((ItemLike)Items.CHAINMAIL_HELMET), new ItemStack((ItemLike)Items.CHAINMAIL_CHESTPLATE), new ItemStack((ItemLike)Items.CHAINMAIL_LEGGINGS), new ItemStack((ItemLike)Items.CHAINMAIL_BOOTS)), new RepairData((TagKey<Item>)ItemTags.GOLD_TOOL_MATERIALS, new ItemStack((ItemLike)Items.GOLDEN_SWORD), new ItemStack((ItemLike)Items.GOLDEN_PICKAXE), new ItemStack((ItemLike)Items.GOLDEN_AXE), new ItemStack((ItemLike)Items.GOLDEN_SHOVEL), new ItemStack((ItemLike)Items.GOLDEN_HOE)), new RepairData((TagKey<Item>)ItemTags.REPAIRS_GOLD_ARMOR, new ItemStack((ItemLike)Items.GOLDEN_HELMET), new ItemStack((ItemLike)Items.GOLDEN_CHESTPLATE), new ItemStack((ItemLike)Items.GOLDEN_LEGGINGS), new ItemStack((ItemLike)Items.GOLDEN_BOOTS)), new RepairData((TagKey<Item>)ItemTags.DIAMOND_TOOL_MATERIALS, new ItemStack((ItemLike)Items.DIAMOND_SWORD), new ItemStack((ItemLike)Items.DIAMOND_PICKAXE), new ItemStack((ItemLike)Items.DIAMOND_AXE), new ItemStack((ItemLike)Items.DIAMOND_SHOVEL), new ItemStack((ItemLike)Items.DIAMOND_HOE)), new RepairData((TagKey<Item>)ItemTags.REPAIRS_DIAMOND_ARMOR, new ItemStack((ItemLike)Items.DIAMOND_HELMET), new ItemStack((ItemLike)Items.DIAMOND_CHESTPLATE), new ItemStack((ItemLike)Items.DIAMOND_LEGGINGS), new ItemStack((ItemLike)Items.DIAMOND_BOOTS)), new RepairData((TagKey<Item>)ItemTags.NETHERITE_TOOL_MATERIALS, new ItemStack((ItemLike)Items.NETHERITE_SWORD), new ItemStack((ItemLike)Items.NETHERITE_AXE), new ItemStack((ItemLike)Items.NETHERITE_HOE), new ItemStack((ItemLike)Items.NETHERITE_SHOVEL), new ItemStack((ItemLike)Items.NETHERITE_PICKAXE)), new RepairData((TagKey<Item>)ItemTags.REPAIRS_NETHERITE_ARMOR, new ItemStack((ItemLike)Items.NETHERITE_BOOTS), new ItemStack((ItemLike)Items.NETHERITE_HELMET), new ItemStack((ItemLike)Items.NETHERITE_LEGGINGS), new ItemStack((ItemLike)Items.NETHERITE_CHESTPLATE)), new RepairData(Ingredient.of((ItemLike)Items.PHANTOM_MEMBRANE).display(), new ItemStack((ItemLike)Items.ELYTRA)), new RepairData((TagKey<Item>)ItemTags.REPAIRS_TURTLE_HELMET, new ItemStack((ItemLike)Items.TURTLE_HELMET)));
    }

    private static Stream<IJeiAnvilRecipe> getRepairRecipes(IVanillaRecipeFactory vanillaRecipeFactory, IIngredientHelper<ItemStack> ingredientHelper) {
        return AnvilRecipeMaker.getRepairData().flatMap(repairData -> AnvilRecipeMaker.getRepairRecipes(repairData, vanillaRecipeFactory, ingredientHelper));
    }

    private static Stream<IJeiAnvilRecipe> getRepairRecipes(RepairData repairData, IVanillaRecipeFactory vanillaRecipeFactory, IIngredientHelper<ItemStack> ingredientHelper) {
        SlotDisplay repairIngredient = repairData.getRepairIngredient();
        List<ItemStack> repairables = repairData.getRepairables();
        Minecraft minecraft = Minecraft.getInstance();
        ContextMap contextmap = SlotDisplayContext.fromLevel((Level)((Level)Objects.requireNonNull(minecraft.level)));
        List repairMaterials = repairIngredient.resolveForStacks(contextmap);
        return repairables.stream().mapMulti((itemStack, consumer) -> {
            String uid = EnchantedBookSubtypeInterpreter.INSTANCE.getStringName((ItemStack)itemStack);
            String ingredientIdPath = ResourceLocationUtil.sanitizePath(uid);
            String itemModId = ingredientHelper.getResourceLocation((ItemStack)itemStack).getNamespace();
            ItemStack damagedThreeQuarters = itemStack.copy();
            damagedThreeQuarters.setDamageValue(damagedThreeQuarters.getMaxDamage() * 3 / 4);
            ItemStack damagedHalf = itemStack.copy();
            damagedHalf.setDamageValue(damagedHalf.getMaxDamage() / 2);
            List<ItemStack> damagedThreeQuartersSingletonList = List.of(damagedThreeQuarters);
            IJeiAnvilRecipe repairWithSame = vanillaRecipeFactory.createAnvilRecipe(damagedThreeQuartersSingletonList, damagedThreeQuartersSingletonList, List.of(damagedHalf), ResourceLocation.fromNamespaceAndPath((String)itemModId, (String)("self_repair." + ingredientIdPath)));
            consumer.accept(repairWithSame);
            if (!repairMaterials.isEmpty()) {
                ItemStack damagedFully = itemStack.copy();
                damagedFully.setDamageValue(damagedFully.getMaxDamage());
                IJeiAnvilRecipe repairWithMaterial = vanillaRecipeFactory.createAnvilRecipe(List.of(damagedFully), (List<ItemStack>)repairMaterials, damagedThreeQuartersSingletonList, ResourceLocation.fromNamespaceAndPath((String)itemModId, (String)("materials_repair." + ingredientIdPath)));
                consumer.accept(repairWithMaterial);
            }
        });
    }

    public static int findLevelsCost(ItemStack leftStack, ItemStack rightStack) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return -1;
        }
        Inventory fakeInventory = new Inventory((Player)player, new EntityEquipment());
        try {
            AnvilMenu repair = new AnvilMenu(0, fakeInventory);
            ((Slot)repair.slots.get(0)).set(leftStack);
            ((Slot)repair.slots.get(1)).set(rightStack);
            return repair.getCost();
        }
        catch (RuntimeException e) {
            String left = ErrorUtil.getItemStackInfo(leftStack);
            String right = ErrorUtil.getItemStackInfo(rightStack);
            LOGGER.error("Could not get anvil level cost for: ({} and {}).", (Object)left, (Object)right, (Object)e);
            return -1;
        }
    }

    private static class RepairData {
        private final SlotDisplay repairIngredient;
        private final List<ItemStack> repairables;

        public RepairData(TagKey<Item> repairTag, ItemStack ... repairables) {
            this.repairIngredient = new SlotDisplay.TagSlotDisplay(repairTag);
            this.repairables = List.of(repairables);
        }

        public RepairData(SlotDisplay repairIngredient, ItemStack ... repairables) {
            this.repairIngredient = repairIngredient;
            this.repairables = List.of(repairables);
        }

        public SlotDisplay getRepairIngredient() {
            return this.repairIngredient;
        }

        public List<ItemStack> getRepairables() {
            return this.repairables;
        }
    }

    private static final class EnchantmentData {
        private final Holder<Enchantment> enchantment;
        private final List<ItemStack> enchantedBooks;

        private EnchantmentData(Holder<Enchantment> enchantment) {
            this.enchantment = enchantment;
            this.enchantedBooks = EnchantmentData.getEnchantedBooks(enchantment);
        }

        public List<ItemStack> getEnchantedBooks(ItemStack ingredient) {
            IPlatformItemStackHelper itemStackHelper = Services.PLATFORM.getItemStackHelper();
            List<ItemStack> list = this.enchantedBooks.stream().filter(enchantedBook -> itemStackHelper.isBookEnchantable(ingredient, (ItemStack)enchantedBook)).toList();
            return list.size() == this.enchantedBooks.size() ? this.enchantedBooks : list;
        }

        private boolean canEnchant(ItemStack ingredient) {
            try {
                return ((Enchantment)this.enchantment.value()).canEnchant(ingredient);
            }
            catch (RuntimeException e) {
                String stackInfo = ErrorUtil.getItemStackInfo(ingredient);
                LOGGER.error("Failed to check if ingredient can be enchanted: {}", (Object)stackInfo, (Object)e);
                return false;
            }
        }

        private static List<ItemStack> getEnchantedBooks(Holder<Enchantment> enchantment) {
            return IntStream.rangeClosed(1, ((Enchantment)enchantment.value()).getMaxLevel()).mapToObj(level -> {
                ItemStack bookEnchant = ENCHANTED_BOOK.copy();
                ItemEnchantments.Mutable itemEnchantments = new ItemEnchantments.Mutable(EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)bookEnchant));
                itemEnchantments.set(enchantment, level);
                EnchantmentHelper.setEnchantments((ItemStack)bookEnchant, (ItemEnchantments)itemEnchantments.toImmutable());
                return bookEnchant;
            }).toList();
        }
    }
}

