/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.neoforge.platform;

import com.google.common.collect.Streams;
import java.util.List;
import java.util.stream.Stream;
import mezz.jei.common.platform.IPlatformIngredientHelper;
import mezz.jei.common.util.RegistryUtil;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.PotionBrewing;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.block.ComposterBlock;

public class IngredientHelper
implements IPlatformIngredientHelper {
    @Override
    public Ingredient createShulkerDyeIngredient(DyeColor color) {
        DyeItem dye = DyeItem.byColor((DyeColor)color);
        TagKey colorTag = color.getTag();
        Registry itemRegistry = RegistryUtil.getRegistry(Registries.ITEM);
        HolderSet coloredItems = itemRegistry.get(colorTag).map(i -> i).orElseGet(HolderSet::empty);
        boolean contains = coloredItems.stream().anyMatch(h -> h.value() == dye);
        Stream colorIngredientStream = coloredItems.stream().map(Holder::value);
        if (!contains) {
            colorIngredientStream = Streams.concat((Stream[])new Stream[]{Stream.of(dye), colorIngredientStream});
        }
        return Ingredient.of(colorIngredientStream);
    }

    @Override
    public List<Ingredient> getPotionContainers(PotionBrewing potionBrewing) {
        return potionBrewing.containers;
    }

    @Override
    public Stream<Ingredient> getPotionIngredients(PotionBrewing potionBrewing) {
        return Stream.concat(potionBrewing.containerMixes.stream(), potionBrewing.potionMixes.stream()).map(PotionBrewing.Mix::ingredient);
    }

    @Override
    public float getCompostValue(ItemStack itemStack) {
        return ComposterBlock.getValue((ItemStack)itemStack);
    }
}

