/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.library.plugins.debug.ingredients;

import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import mezz.jei.api.gui.builder.ITooltipBuilder;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.common.gui.JeiTooltip;
import mezz.jei.common.platform.IPlatformRenderHelper;
import mezz.jei.common.platform.Services;
import mezz.jei.library.plugins.debug.ingredients.ErrorIngredient;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.TooltipFlag;

public class ErrorIngredientRenderer
implements IIngredientRenderer<ErrorIngredient> {
    private static final List<RenderType> RENDER_TYPES = List.of(RenderType.gui(), RenderType.glint(), RenderType.debugFilledBox(), RenderType.guiOverlay(), RenderType.guiGhostRecipeOverlay(), RenderType.guiTextHighlight());
    private final IIngredientHelper<ErrorIngredient> ingredientHelper;

    public ErrorIngredientRenderer(IIngredientHelper<ErrorIngredient> ingredientHelper) {
        this.ingredientHelper = ingredientHelper;
    }

    @Override
    public void render(GuiGraphics guiGraphics, ErrorIngredient ingredient) {
        Minecraft minecraft = Minecraft.getInstance();
        switch (ingredient.crashType()) {
            case RenderBreakVertexBufferCrash: {
                IPlatformRenderHelper renderHelper = Services.PLATFORM.getRenderHelper();
                MultiBufferSource bufferSource = renderHelper.getBufferSource(guiGraphics);
                for (RenderType renderType : RENDER_TYPES) {
                    VertexConsumer buffer = bufferSource.getBuffer(renderType);
                    buffer.addVertex(0.0f, 0.0f, 0.0f).setColor(100);
                }
                throw new RuntimeException("intentional render crash for testing");
            }
            case TooltipCrash: {
                Font font = this.getFontRenderer(minecraft, ingredient);
                guiGraphics.drawString(font, "JEI", 0, 0, -65536, false);
                guiGraphics.drawString(font, "TEST", 0, 8, -65536, false);
            }
        }
    }

    @Override
    public List<Component> getTooltip(ErrorIngredient ingredient, TooltipFlag tooltipFlag) {
        JeiTooltip tooltip = new JeiTooltip();
        this.getTooltip((ITooltipBuilder)tooltip, ingredient, tooltipFlag);
        return tooltip.toLegacyToComponents();
    }

    @Override
    public void getTooltip(ITooltipBuilder tooltip, ErrorIngredient ingredient, TooltipFlag tooltipFlag) {
        if (ingredient.crashType() == ErrorIngredient.CrashType.TooltipCrash) {
            throw new RuntimeException("intentional tooltip crash for testing");
        }
        String displayName = this.ingredientHelper.getDisplayName(ingredient);
        tooltip.add((FormattedText)Component.literal((String)displayName));
        MutableComponent debugIngredient = Component.literal((String)"debug ingredient");
        tooltip.add((FormattedText)debugIngredient.withStyle(ChatFormatting.GRAY));
    }
}

