/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.library.load;

import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableSetMultimap;
import java.util.List;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.helpers.IColorHelper;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.helpers.IPlatformFluidHelper;
import mezz.jei.api.helpers.IStackHelper;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.ingredients.subtypes.ISubtypeManager;
import mezz.jei.api.recipe.advanced.IRecipeManagerPlugin;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.category.extensions.IRecipeCategoryDecorator;
import mezz.jei.api.recipe.transfer.IRecipeTransferManager;
import mezz.jei.api.recipe.types.IRecipeType;
import mezz.jei.api.registration.IAdvancedRegistration;
import mezz.jei.api.registration.IExtraIngredientRegistration;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IIngredientAliasRegistration;
import mezz.jei.api.registration.IModInfoRegistration;
import mezz.jei.api.registration.IModIngredientRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import mezz.jei.api.registration.IVanillaCategoryExtensionRegistration;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.api.runtime.IJeiFeatures;
import mezz.jei.api.runtime.IScreenHelper;
import mezz.jei.common.Internal;
import mezz.jei.common.JeiFeatures;
import mezz.jei.common.config.IClientToggleState;
import mezz.jei.common.config.IIngredientFilterConfig;
import mezz.jei.common.network.IConnectionToServer;
import mezz.jei.common.platform.IPlatformFluidHelperInternal;
import mezz.jei.common.platform.Services;
import mezz.jei.common.util.StackHelper;
import mezz.jei.core.util.LoggedTimer;
import mezz.jei.library.config.EditModeConfig;
import mezz.jei.library.config.IModIdFormatConfig;
import mezz.jei.library.config.RecipeCategorySortingConfig;
import mezz.jei.library.focus.FocusFactory;
import mezz.jei.library.gui.helpers.GuiHelper;
import mezz.jei.library.helpers.CodecHelper;
import mezz.jei.library.helpers.ModIdHelper;
import mezz.jei.library.ingredients.IngredientBlacklistInternal;
import mezz.jei.library.ingredients.IngredientVisibility;
import mezz.jei.library.ingredients.subtypes.SubtypeInterpreters;
import mezz.jei.library.ingredients.subtypes.SubtypeManager;
import mezz.jei.library.load.PluginCaller;
import mezz.jei.library.load.registration.AdvancedRegistration;
import mezz.jei.library.load.registration.GuiHandlerRegistration;
import mezz.jei.library.load.registration.IngredientManagerBuilder;
import mezz.jei.library.load.registration.ModInfoRegistration;
import mezz.jei.library.load.registration.RecipeCatalystRegistration;
import mezz.jei.library.load.registration.RecipeCategoryRegistration;
import mezz.jei.library.load.registration.RecipeManagerPluginHelper;
import mezz.jei.library.load.registration.RecipeRegistration;
import mezz.jei.library.load.registration.RecipeTransferRegistration;
import mezz.jei.library.load.registration.SubtypeRegistration;
import mezz.jei.library.load.registration.VanillaCategoryExtensionRegistration;
import mezz.jei.library.plugins.vanilla.VanillaPlugin;
import mezz.jei.library.plugins.vanilla.VanillaRecipeFactory;
import mezz.jei.library.plugins.vanilla.anvil.SmithingRecipeCategory;
import mezz.jei.library.plugins.vanilla.crafting.CraftingRecipeCategory;
import mezz.jei.library.recipes.RecipeManager;
import mezz.jei.library.recipes.RecipeManagerInternal;
import mezz.jei.library.runtime.JeiHelpers;
import mezz.jei.library.startup.StartData;
import mezz.jei.library.transfer.RecipeTransferHandlerHelper;
import org.jetbrains.annotations.Unmodifiable;

public final class PluginLoader {
    private PluginLoader() {
    }

    public static SubtypeManager registerSubtypes(StartData data) {
        IPlatformFluidHelperInternal fluidHelper = Services.PLATFORM.getFluidHelper();
        List<IModPlugin> plugins = data.plugins();
        SubtypeRegistration subtypeRegistration = new SubtypeRegistration();
        PluginCaller.callOnPlugins("Registering item subtypes", plugins, p -> p.registerItemSubtypes((ISubtypeRegistration)subtypeRegistration));
        PluginCaller.callOnPlugins("Registering fluid subtypes", plugins, p -> p.registerFluidSubtypes((ISubtypeRegistration)subtypeRegistration, (IPlatformFluidHelper)fluidHelper));
        SubtypeInterpreters subtypeInterpreters = subtypeRegistration.getInterpreters();
        return new SubtypeManager(subtypeInterpreters);
    }

    public static IIngredientManager registerIngredients(StartData data, SubtypeManager subtypeManager, IColorHelper colorHelper, IIngredientFilterConfig ingredientFilterConfig) {
        List<IModPlugin> plugins = data.plugins();
        IngredientManagerBuilder ingredientManagerBuilder = new IngredientManagerBuilder(subtypeManager, colorHelper);
        PluginCaller.callOnPlugins("Registering ingredients", plugins, p -> p.registerIngredients((IModIngredientRegistration)ingredientManagerBuilder));
        PluginCaller.callOnPlugins("Registering extra ingredients", plugins, p -> p.registerExtraIngredients((IExtraIngredientRegistration)ingredientManagerBuilder));
        if (ingredientFilterConfig.getSearchIngredientAliases()) {
            PluginCaller.callOnPlugins("Registering search ingredient aliases", plugins, p -> p.registerIngredientAliases((IIngredientAliasRegistration)ingredientManagerBuilder));
        }
        return ingredientManagerBuilder.build();
    }

    public static ImmutableSetMultimap<String, String> registerModAliases(StartData data, IIngredientFilterConfig ingredientFilterConfig) {
        List<IModPlugin> plugins = data.plugins();
        if (!ingredientFilterConfig.getSearchModAliases()) {
            return ImmutableSetMultimap.of();
        }
        ModInfoRegistration modInfoRegistration = new ModInfoRegistration();
        PluginCaller.callOnPlugins("Registering Mod Info", plugins, p -> p.registerModInfo((IModInfoRegistration)modInfoRegistration));
        return modInfoRegistration.getModAliases();
    }

    public static JeiHelpers createJeiHelpers(ImmutableSetMultimap<String, String> modAliases, IModIdFormatConfig modIdFormatConfig, IColorHelper colorHelper, EditModeConfig editModeConfig, FocusFactory focusFactory, CodecHelper codecHelper, IIngredientManager ingredientManager, SubtypeManager subtypeManager) {
        VanillaRecipeFactory vanillaRecipeFactory = new VanillaRecipeFactory(ingredientManager);
        StackHelper stackHelper = new StackHelper((ISubtypeManager)subtypeManager);
        GuiHelper guiHelper = new GuiHelper(ingredientManager);
        ModIdHelper modIdHelper = new ModIdHelper(modIdFormatConfig, ingredientManager, modAliases);
        IClientToggleState toggleState = Internal.getClientToggleState();
        IngredientBlacklistInternal blacklist = new IngredientBlacklistInternal();
        ingredientManager.registerIngredientListener((IIngredientManager.IIngredientListener)blacklist);
        IngredientVisibility ingredientVisibility = new IngredientVisibility(blacklist, toggleState, editModeConfig, ingredientManager);
        return new JeiHelpers(guiHelper, (IStackHelper)stackHelper, modIdHelper, focusFactory, colorHelper, ingredientManager, vanillaRecipeFactory, codecHelper, ingredientVisibility);
    }

    private static @Unmodifiable List<IRecipeCategory<?>> createRecipeCategories(List<IModPlugin> plugins, VanillaPlugin vanillaPlugin, JeiHelpers jeiHelpers) {
        RecipeCategoryRegistration recipeCategoryRegistration = new RecipeCategoryRegistration(jeiHelpers);
        PluginCaller.callOnPlugins("Registering categories", plugins, p -> p.registerCategories((IRecipeCategoryRegistration)recipeCategoryRegistration));
        CraftingRecipeCategory craftingCategory = vanillaPlugin.getCraftingCategory().orElseThrow(() -> new NullPointerException("vanilla crafting category"));
        SmithingRecipeCategory smithingCategory = vanillaPlugin.getSmithingCategory().orElseThrow(() -> new NullPointerException("vanilla smithing category"));
        VanillaCategoryExtensionRegistration vanillaCategoryExtensionRegistration = new VanillaCategoryExtensionRegistration(craftingCategory, smithingCategory, jeiHelpers);
        PluginCaller.callOnPlugins("Registering vanilla category extensions", plugins, p -> p.registerVanillaCategoryExtensions((IVanillaCategoryExtensionRegistration)vanillaCategoryExtensionRegistration));
        return recipeCategoryRegistration.getRecipeCategories();
    }

    public static IScreenHelper createGuiScreenHelper(List<IModPlugin> plugins, IJeiHelpers jeiHelpers, IIngredientManager ingredientManager) {
        GuiHandlerRegistration guiHandlerRegistration = new GuiHandlerRegistration(jeiHelpers);
        PluginCaller.callOnPlugins("Registering gui handlers", plugins, p -> p.registerGuiHandlers((IGuiHandlerRegistration)guiHandlerRegistration));
        return guiHandlerRegistration.createGuiScreenHelper(ingredientManager);
    }

    public static IRecipeTransferManager createRecipeTransferManager(VanillaPlugin vanillaPlugin, List<IModPlugin> plugins, JeiHelpers jeiHelpers, IConnectionToServer connectionToServer) {
        IStackHelper stackHelper = jeiHelpers.getStackHelper();
        CraftingRecipeCategory craftingCategory = vanillaPlugin.getCraftingCategory().orElseThrow(() -> new NullPointerException("vanilla crafting category"));
        RecipeTransferHandlerHelper handlerHelper = new RecipeTransferHandlerHelper(stackHelper, craftingCategory);
        RecipeTransferRegistration recipeTransferRegistration = new RecipeTransferRegistration(stackHelper, handlerHelper, jeiHelpers, connectionToServer);
        PluginCaller.callOnPlugins("Registering recipes transfer handlers", plugins, p -> p.registerRecipeTransferHandlers((IRecipeTransferRegistration)recipeTransferRegistration));
        return recipeTransferRegistration.createRecipeTransferManager();
    }

    public static RecipeManager createRecipeManager(List<IModPlugin> plugins, VanillaPlugin vanillaPlugin, RecipeCategorySortingConfig recipeCategorySortingConfig, JeiHelpers jeiHelpers, IIngredientManager ingredientManager) {
        List<IRecipeCategory<?>> recipeCategories = PluginLoader.createRecipeCategories(plugins, vanillaPlugin, jeiHelpers);
        RecipeCatalystRegistration recipeCatalystRegistration = new RecipeCatalystRegistration(ingredientManager, jeiHelpers);
        PluginCaller.callOnPlugins("Registering recipe catalysts", plugins, p -> p.registerRecipeCatalysts((IRecipeCatalystRegistration)recipeCatalystRegistration));
        ImmutableListMultimap<IRecipeType<?>, ITypedIngredient<?>> recipeCatalysts = recipeCatalystRegistration.getRecipeCatalysts();
        LoggedTimer timer = new LoggedTimer();
        timer.start("Building recipe registry");
        RecipeManagerInternal recipeManagerInternal = new RecipeManagerInternal(recipeCategories, recipeCatalysts, ingredientManager, recipeCategorySortingConfig, jeiHelpers.getIngredientVisibility());
        timer.stop();
        JeiFeatures jeiFeatures = Internal.getJeiFeatures();
        RecipeManagerPluginHelper recipeManagerPluginHelper = new RecipeManagerPluginHelper(recipeManagerInternal);
        AdvancedRegistration advancedRegistration = new AdvancedRegistration(jeiHelpers, (IJeiFeatures)jeiFeatures, recipeManagerPluginHelper);
        PluginCaller.callOnPlugins("Registering advanced plugins", plugins, p -> p.registerAdvanced((IAdvancedRegistration)advancedRegistration));
        List<IRecipeManagerPlugin> recipeManagerPlugins = advancedRegistration.getRecipeManagerPlugins();
        ImmutableListMultimap<IRecipeType<?>, IRecipeCategoryDecorator<?>> recipeCategoryDecorators = advancedRegistration.getRecipeCategoryDecorators();
        recipeManagerInternal.addPlugins(recipeManagerPlugins);
        recipeManagerInternal.addDecorators(recipeCategoryDecorators);
        RecipeRegistration recipeRegistration = new RecipeRegistration(jeiHelpers, ingredientManager, recipeManagerInternal);
        PluginCaller.callOnPlugins("Registering recipes", plugins, p -> p.registerRecipes((IRecipeRegistration)recipeRegistration));
        recipeManagerInternal.compact();
        return new RecipeManager(recipeManagerInternal, ingredientManager);
    }
}

