/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.library.focus;

import java.util.Collection;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.IFocusFactory;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.common.util.ErrorUtil;
import mezz.jei.library.focus.Focus;
import mezz.jei.library.focus.FocusGroup;

public class FocusFactory
implements IFocusFactory {
    private final IIngredientManager ingredientManager;

    public FocusFactory(IIngredientManager ingredientManager) {
        this.ingredientManager = ingredientManager;
    }

    public <V> IFocus<V> createFocus(RecipeIngredientRole role, IIngredientType<V> ingredientType, V ingredient) {
        ErrorUtil.checkNotNull((Object)role, (String)"role");
        ErrorUtil.checkNotNull(ingredientType, (String)"ingredientType");
        ErrorUtil.checkNotNull(ingredient, (String)"ingredient");
        return Focus.createFromApi(this.ingredientManager, role, ingredientType, ingredient);
    }

    public <V> IFocus<V> createFocus(RecipeIngredientRole role, ITypedIngredient<V> typedIngredient) {
        ErrorUtil.checkNotNull((Object)role, (String)"role");
        ErrorUtil.checkNotNull(typedIngredient, (String)"typedIngredient");
        return Focus.createFromApi(this.ingredientManager, role, typedIngredient);
    }

    public IFocusGroup createFocusGroup(Collection<? extends IFocus<?>> focuses) {
        return FocusGroup.create(focuses, this.ingredientManager);
    }

    public IFocusGroup getEmptyFocusGroup() {
        return FocusGroup.EMPTY;
    }
}

