/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.overlay.bookmarks;

import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import mezz.jei.api.gui.IRecipeLayoutDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotView;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.common.Internal;
import mezz.jei.common.util.MathUtil;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_5632;
import net.minecraft.class_5684;

public class IngredientsTooltipComponent
implements class_5684,
class_5632 {
    private static final int MAX_INGREDIENTS_PER_ROW = 16;
    private static final int INGREDIENT_SIZE = 18;
    private static final int INGREDIENT_PADDING = 1;
    private final List<RenderElement<?>> ingredients;

    public IngredientsTooltipComponent(IRecipeLayoutDrawable<?> layout) {
        IIngredientManager ingredientManager = Internal.getJeiRuntime().getIngredientManager();
        IRecipeSlotsView recipeSlotsView = layout.getRecipeSlotsView();
        HashMap summary = new HashMap();
        recipeSlotsView.getSlotViews(RecipeIngredientRole.INPUT).stream().map(IRecipeSlotView::getDisplayedIngredient).filter(Optional::isPresent).map(Optional::get).forEach(ingredient -> IngredientsTooltipComponent.addToSummary(ingredient, ingredientManager, summary));
        Comparator<SummaryElement> comparator = Comparator.comparingLong(SummaryElement::getAmount);
        this.ingredients = summary.values().stream().sorted(comparator.reversed()).map(e -> RenderElement.create(e, ingredientManager)).toList();
    }

    private static <T> void addToSummary(ITypedIngredient<T> typedIngredient, IIngredientManager ingredientManager, Map<Object, SummaryElement<?>> summary) {
        T ingredient;
        IIngredientType<T> type = typedIngredient.getType();
        IIngredientHelper<T> helper = ingredientManager.getIngredientHelper(type);
        long ingredientAmount = helper.getAmount(ingredient = typedIngredient.getIngredient());
        if (ingredientAmount == -1L) {
            return;
        }
        Object uid = IngredientsTooltipComponent.getUid(typedIngredient, ingredientManager);
        summary.compute(uid, (k, v) -> {
            if (v == null) {
                return SummaryElement.create(typedIngredient, ingredientAmount);
            }
            long newAmount = v.getAmount() + ingredientAmount;
            v.setAmount(newAmount);
            return v;
        });
    }

    private static <T> Object getUid(ITypedIngredient<T> typedIngredient, IIngredientManager ingredientManager) {
        IIngredientType<T> type = typedIngredient.getType();
        IIngredientHelper<T> ingredientHelper = ingredientManager.getIngredientHelper(type);
        return ingredientHelper.getUid(typedIngredient, UidContext.Recipe);
    }

    public int method_32661(class_327 font) {
        return 4 + 18 * MathUtil.divideCeil(this.ingredients.size(), 16);
    }

    public int method_32664(class_327 font) {
        return 18 * Math.min(this.ingredients.size(), 16);
    }

    public void method_32666(class_327 font, int x, int y, int p_368529_, int p_368584_, class_332 guiGraphics) {
        for (int i = 0; i < this.ingredients.size(); ++i) {
            int elementX = 1 + x + i % 16 * 18;
            int elementY = 1 + y + i / 16 * 18;
            RenderElement<?> renderElement = this.ingredients.get(i);
            class_4587 pose = guiGraphics.method_51448();
            pose.method_22903();
            pose.method_46416((float)elementX, (float)elementY, 0.0f);
            renderElement.render(guiGraphics);
            pose.method_22909();
        }
    }

    private record RenderElement<T>(IIngredientRenderer<T> renderer, T ingredient) {
        public static <T> RenderElement<T> create(SummaryElement<T> summaryElement, IIngredientManager ingredientManager) {
            ITypedIngredient<T> typedIngredient = summaryElement.getIngredient();
            IIngredientType<T> type = typedIngredient.getType();
            IIngredientHelper<T> helper = ingredientManager.getIngredientHelper(type);
            IIngredientRenderer<T> renderer = ingredientManager.getIngredientRenderer(type);
            T ingredient = helper.copyWithAmount(typedIngredient.getIngredient(), summaryElement.getAmount());
            return new RenderElement<T>(renderer, ingredient);
        }

        public void render(class_332 guiGraphics) {
            this.renderer.render(guiGraphics, this.ingredient);
        }
    }

    private static class SummaryElement<T> {
        private final ITypedIngredient<T> ingredient;
        private long amount;

        public static <T> SummaryElement<T> create(ITypedIngredient<T> ingredient, long amount) {
            return new SummaryElement<T>(ingredient, amount);
        }

        private SummaryElement(ITypedIngredient<T> ingredient, long amount) {
            this.ingredient = ingredient;
            this.amount = amount;
        }

        public ITypedIngredient<T> getIngredient() {
            return this.ingredient;
        }

        public long getAmount() {
            return this.amount;
        }

        public void setAmount(long amount) {
            this.amount = amount;
        }
    }
}

