package mezz.jei.common.util;

import java.util.Collection;
import net.minecraft.class_241;
import net.minecraft.class_327;
import net.minecraft.class_5481;
import net.minecraft.class_768;
import net.minecraft.class_8030;

public final class MathUtil {
	private MathUtil() {

	}

	@SuppressWarnings("NumericCastThatLosesPrecision")
	public static int divideCeil(int numerator, int denominator) {
		return (int) Math.ceil((float) numerator / denominator);
	}

	public static boolean intersects(Collection<ImmutableRect2i> areas, ImmutableRect2i comparisonArea) {
		return areas.stream()
			.anyMatch(comparisonArea::intersects);
	}

	public static boolean contains(ImmutableRect2i rect, double x, double y) {
		return rect.contains(x, y);
	}

	public static boolean contains(class_768 rect, double x, double y) {
		return x >= rect.method_3321() &&
			y >= rect.method_3322() &&
			x < rect.method_3321() + rect.method_3319() &&
			y < rect.method_3322() + rect.method_3320();
	}

	public static boolean contains(class_8030 rect, double x, double y) {
		return x >= rect.method_49620() &&
			x <= rect.method_49621() &&
			y >= rect.method_49618() &&
			y <= rect.method_49619();
	}

	public static ImmutableRect2i union(ImmutableRect2i rect1, ImmutableRect2i rect2) {
		if (rect1.isEmpty()) {
			return rect2;
		}
		if (rect2.isEmpty()) {
			return rect1;
		}
		long tx2 = rect1.getWidth();
		long ty2 = rect1.getHeight();
		long rx2 = rect2.getWidth();
		long ry2 = rect2.getHeight();
		int tx1 = rect1.getX();
		int ty1 = rect1.getY();
		tx2 += tx1;
		ty2 += ty1;
		int rx1 = rect2.getX();
		int ry1 = rect2.getY();
		rx2 += rx1;
		ry2 += ry1;
		if (tx1 > rx1) {
			tx1 = rx1;
		}
		if (ty1 > ry1) {
			ty1 = ry1;
		}
		if (tx2 < rx2) {
			tx2 = rx2;
		}
		if (ty2 < ry2) {
			ty2 = ry2;
		}
		tx2 -= tx1;
		ty2 -= ty1;
		tx2 = Math.min(tx2, Integer.MAX_VALUE);
		ty2 = Math.min(ty2, Integer.MAX_VALUE);
		return new ImmutableRect2i(tx1, ty1, (int) tx2, (int) ty2);
	}

	public static ImmutableRect2i centerTextArea(ImmutableRect2i outer, class_327 fontRenderer, String text) {
		int width = fontRenderer.method_1727(text);
		int height = fontRenderer.field_2000;
		return centerArea(outer, width, height);
	}

	public static ImmutableRect2i centerTextArea(ImmutableRect2i outer, class_327 fontRenderer, class_5481 text) {
		int width = fontRenderer.method_30880(text);
		int height = fontRenderer.field_2000;
		return centerArea(outer, width, height);
	}

	public static ImmutableRect2i centerArea(ImmutableRect2i outer, int width, int height) {
		return new ImmutableRect2i(
			outer.getX() + Math.round((outer.getWidth() - width) / 2.0f),
			outer.getY() + Math.round((outer.getHeight() - height) / 2.0f),
			width,
			height
		);
	}

	public static double distance(class_241 start, class_241 end) {
		double a = start.field_1343 - end.field_1343;
		double b = start.field_1342 - end.field_1342;
		return Math.sqrt(a * a + b * b);
	}
}
