/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.library.render;

import com.google.common.base.Preconditions;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredientTypeWithSubtypes;
import mezz.jei.common.platform.IPlatformFluidHelperInternal;
import mezz.jei.common.platform.IPlatformRenderHelper;
import mezz.jei.common.platform.Services;
import net.minecraft.class_1058;
import net.minecraft.class_124;
import net.minecraft.class_1836;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_5250;
import net.minecraft.class_7764;
import net.minecraft.class_8690;

public class FluidTankRenderer<T>
implements IIngredientRenderer<T> {
    private static final NumberFormat nf = NumberFormat.getIntegerInstance();
    private static final int MIN_FLUID_HEIGHT = 1;
    private final IPlatformFluidHelperInternal<T> fluidHelper;
    private final long capacity;
    private final TooltipMode tooltipMode;
    private final int width;
    private final int height;

    public FluidTankRenderer(IPlatformFluidHelperInternal<T> fluidHelper) {
        this(fluidHelper, fluidHelper.bucketVolume(), TooltipMode.ITEM_LIST, 16, 16);
    }

    public FluidTankRenderer(IPlatformFluidHelperInternal<T> fluidHelper, long capacity, boolean showCapacity, int width, int height) {
        this(fluidHelper, capacity, showCapacity ? TooltipMode.SHOW_AMOUNT_AND_CAPACITY : TooltipMode.SHOW_AMOUNT, width, height);
    }

    private FluidTankRenderer(IPlatformFluidHelperInternal<T> fluidHelper, long capacity, TooltipMode tooltipMode, int width, int height) {
        Preconditions.checkArgument((capacity > 0L ? 1 : 0) != 0, (Object)"capacity must be > 0");
        Preconditions.checkArgument((width > 0 ? 1 : 0) != 0, (Object)"width must be > 0");
        Preconditions.checkArgument((height > 0 ? 1 : 0) != 0, (Object)"height must be > 0");
        this.fluidHelper = fluidHelper;
        this.capacity = capacity;
        this.tooltipMode = tooltipMode;
        this.width = width;
        this.height = height;
    }

    @Override
    public void render(class_332 guiGraphics, T fluidStack) {
        this.render(guiGraphics, fluidStack, 0, 0);
    }

    @Override
    public void render(class_332 guiGraphics, T ingredient, int posX, int posY) {
        IIngredientTypeWithSubtypes type = this.fluidHelper.getFluidIngredientType();
        class_3611 fluid = type.getBase(ingredient);
        if (fluid.method_15780(class_3612.field_15906)) {
            return;
        }
        this.fluidHelper.getStillFluidSprite(ingredient).ifPresent(fluidStillSprite -> {
            int fluidColor = this.fluidHelper.getColorTint(ingredient);
            long amount = this.fluidHelper.getAmount(ingredient);
            if (amount > 0L) {
                long longScaledAmount = amount * (long)this.height / this.capacity;
                int scaledAmount = Math.clamp(longScaledAmount, 1, this.height);
                FluidTankRenderer.drawTiledSprite(guiGraphics, this.width, this.height, fluidColor, scaledAmount, fluidStillSprite, posX, posY);
            }
        });
    }

    private static void drawTiledSprite(class_332 guiGraphics, int tiledWidth, int tiledHeight, int color, int scaledAmount, class_1058 sprite, int posX, int posY) {
        IPlatformRenderHelper renderHelper = Services.PLATFORM.getRenderHelper();
        class_7764 spriteContents = sprite.method_45851();
        class_8690.class_8694 tileScaling = new class_8690.class_8694(spriteContents.method_45807(), spriteContents.method_45815());
        posY = posY + tiledHeight - scaledAmount;
        guiGraphics.method_44379(posX, posY, posX + tiledWidth, posY + scaledAmount);
        renderHelper.blitTiledSprite(guiGraphics, class_1921::method_62277, sprite, tileScaling, posX, posY, tiledWidth, scaledAmount, color);
        guiGraphics.method_44380();
    }

    @Override
    public List<class_2561> getTooltip(T fluidStack, class_1836 tooltipFlag) {
        ArrayList<class_2561> tooltip = new ArrayList<class_2561>();
        IIngredientTypeWithSubtypes type = this.fluidHelper.getFluidIngredientType();
        class_3611 fluidType = type.getBase(fluidStack);
        if (fluidType.method_15780(class_3612.field_15906)) {
            return tooltip;
        }
        this.fluidHelper.getTooltip(tooltip, fluidStack, tooltipFlag);
        long amount = this.fluidHelper.getAmount(fluidStack);
        long milliBuckets = amount * 1000L / this.fluidHelper.bucketVolume();
        if (this.tooltipMode == TooltipMode.SHOW_AMOUNT_AND_CAPACITY) {
            class_5250 amountString = class_2561.method_43469((String)"jei.tooltip.liquid.amount.with.capacity", (Object[])new Object[]{nf.format(milliBuckets), nf.format(this.capacity)});
            tooltip.add((class_2561)amountString.method_27692(class_124.field_1080));
        } else if (this.tooltipMode == TooltipMode.SHOW_AMOUNT) {
            class_5250 amountString = class_2561.method_43469((String)"jei.tooltip.liquid.amount", (Object[])new Object[]{nf.format(milliBuckets)});
            tooltip.add((class_2561)amountString.method_27692(class_124.field_1080));
        }
        return tooltip;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    static enum TooltipMode {
        SHOW_AMOUNT,
        SHOW_AMOUNT_AND_CAPACITY,
        ITEM_LIST;

    }
}

