package mezz.jei.library.plugins.vanilla.grindstone;

import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.placement.HorizontalAlignment;
import mezz.jei.api.gui.widgets.IRecipeExtrasBuilder;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.category.AbstractRecipeCategory;
import mezz.jei.api.recipe.vanilla.IJeiGrindstoneRecipe;
import net.minecraft.class_1799;
import net.minecraft.class_2246;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.List;

public class GrindstoneRecipeCategory extends AbstractRecipeCategory<IJeiGrindstoneRecipe> {
	private static final String topSlotName = "topSlot";
	private static final String bottomSlotName = "bottomSlot";

	public GrindstoneRecipeCategory(IGuiHelper guiHelper) {
		super(
				RecipeTypes.GRINDSTONE,
				class_2246.field_16337.method_9518(),
				guiHelper.createDrawableItemLike(class_2246.field_16337),
				125,
				52
		);
	}

	@Override
	public void setRecipe(IRecipeLayoutBuilder builder, IJeiGrindstoneRecipe recipe, @NotNull IFocusGroup focuses) {
		List<class_1799> topInputs = recipe.getTopInputs();
		List<class_1799> bottomInputs = recipe.getBottomInputs();
		List<class_1799> outputs = recipe.getOutputs();

		IRecipeSlotBuilder topInputSlot = builder.addInputSlot(1, 1)
				.addItemStacks(topInputs)
				.setStandardSlotBackground()
				.setSlotName(topSlotName);

		IRecipeSlotBuilder bottomInputSlot = builder.addInputSlot(1, 24)
				.addItemStacks(bottomInputs)
				.setStandardSlotBackground()
				.setSlotName(bottomSlotName);

		int outputSlotXPosition = 52;
		int outputSlotYPosition = 13;
		IRecipeSlotBuilder outputSlot = recipe.isOutputRenderOnly() ?
				builder.addSlot(RecipeIngredientRole.RENDER_ONLY, outputSlotXPosition, outputSlotYPosition) :
				builder.addOutputSlot(outputSlotXPosition, outputSlotYPosition);
		outputSlot.setOutputSlotBackground().addItemStacks(outputs);

		if (topInputs.size() == bottomInputs.size()) {
			if (topInputs.size() == outputs.size()) {
				builder.createFocusLink(topInputSlot, bottomInputSlot, outputSlot);
			}
		} else if (topInputs.size() == outputs.size() && bottomInputs.size() == 1) {
			builder.createFocusLink(topInputSlot, outputSlot);
		} else if (bottomInputs.size() == outputs.size() && topInputs.size() == 1) {
			builder.createFocusLink(bottomInputSlot, outputSlot);
		}
	}

	@Override
	public void createRecipeExtras(IRecipeExtrasBuilder builder, IJeiGrindstoneRecipe recipe, @NotNull IFocusGroup focuses) {
		builder.addRecipeArrow().setPosition(20, 12);

		int maxXpReward = recipe.getMaxXpReward();
		if (maxXpReward > 0) {
			int minXpReward = recipe.getMinXpReward();
			class_2561 text = class_2561.method_43469("gui.jei.category.grindstone.experience", minXpReward, maxXpReward);
			builder.addText(text, getWidth(), 10)
				.setPosition(0, 43)
				.setColor(0xFF80FF20)
				.setShadow(true)
				.setTextAlignment(HorizontalAlignment.RIGHT);
		}
	}

	@Override
	public @Nullable class_2960 getRegistryName(IJeiGrindstoneRecipe recipe) {
		return recipe.getUid();
	}
}
