/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.library.plugins.debug.ingredients;

import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.common.platform.IPlatformRenderHelper;
import mezz.jei.common.platform.Services;
import mezz.jei.library.plugins.debug.ingredients.ErrorIngredient;
import net.minecraft.class_124;
import net.minecraft.class_1836;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5250;

public class ErrorIngredientRenderer
implements IIngredientRenderer<ErrorIngredient> {
    private static final List<class_1921> RENDER_TYPES = List.of(class_1921.method_51784(), class_1921.method_23590(), class_1921.method_49047(), class_1921.method_51785(), class_1921.method_51787(), class_1921.method_51786());
    private final IIngredientHelper<ErrorIngredient> ingredientHelper;

    public ErrorIngredientRenderer(IIngredientHelper<ErrorIngredient> ingredientHelper) {
        this.ingredientHelper = ingredientHelper;
    }

    @Override
    public void render(class_332 guiGraphics, ErrorIngredient ingredient) {
        class_310 minecraft = class_310.method_1551();
        switch (ingredient.crashType()) {
            case RenderBreakVertexBufferCrash: {
                IPlatformRenderHelper renderHelper = Services.PLATFORM.getRenderHelper();
                class_4597 bufferSource = renderHelper.getBufferSource(guiGraphics);
                for (class_1921 renderType : RENDER_TYPES) {
                    class_4588 buffer = bufferSource.getBuffer(renderType);
                    buffer.method_22912(0.0f, 0.0f, 0.0f).method_39415(100);
                }
                throw new RuntimeException("intentional render crash for testing");
            }
            case TooltipCrash: {
                class_327 font = this.getFontRenderer(minecraft, ingredient);
                guiGraphics.method_51433(font, "JEI", 0, 0, -65536, false);
                guiGraphics.method_51433(font, "TEST", 0, 8, -65536, false);
            }
        }
    }

    @Override
    public List<class_2561> getTooltip(ErrorIngredient ingredient, class_1836 tooltipFlag) {
        if (ingredient.crashType() == ErrorIngredient.CrashType.TooltipCrash) {
            throw new RuntimeException("intentional tooltip crash for testing");
        }
        ArrayList<class_2561> tooltip = new ArrayList<class_2561>();
        String displayName = this.ingredientHelper.getDisplayName(ingredient);
        tooltip.add((class_2561)class_2561.method_43470((String)displayName));
        class_5250 debugIngredient = class_2561.method_43470((String)"error ingredient");
        tooltip.add((class_2561)debugIngredient.method_27692(class_124.field_1080));
        return tooltip;
    }
}

