package mezz.jei.fabric.events;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.minecraft.class_1060;
import net.minecraft.class_3304;

public class JeiLifecycleEvents {
	public static final Event<Runnable> GAME_START =
			EventFactory.createArrayBacked(Runnable.class, callbacks -> () -> {
				for (Runnable callback : callbacks) {
					callback.run();
				}
			});

	public static final Event<Runnable> GAME_STOP =
			EventFactory.createArrayBacked(Runnable.class, callbacks -> () -> {
				for (Runnable callback : callbacks) {
					callback.run();
				}
			});

	public static final Event<Runnable> AFTER_RECIPE_SYNC =
			EventFactory.createArrayBacked(Runnable.class, callbacks -> () -> {
				for (Runnable callback : callbacks) {
					callback.run();
				}
			});

	public static final Event<RegisterResourceReloadListener> REGISTER_RESOURCE_RELOAD_LISTENER =
			EventFactory.createArrayBacked(RegisterResourceReloadListener.class, callbacks -> (resourceManager, textureManager) -> {
				for (RegisterResourceReloadListener callback : callbacks) {
					callback.registerResourceReloadListener(resourceManager, textureManager);
				}
			});

	@Environment(EnvType.CLIENT)
	@FunctionalInterface
	public interface RegisterResourceReloadListener {
		void registerResourceReloadListener(class_3304 resourceManager, class_1060 textureManager);
	}
}
