package mezz.jei.common.gui.elements;

import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.common.Constants;
import mezz.jei.common.gui.textures.JeiSpriteUploader;
import net.minecraft.class_1058;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4588;
import org.joml.Matrix4f;

public class DrawableSprite implements IDrawableStatic {
	private final JeiSpriteUploader spriteUploader;
	private final class_2960 location;
	private final int width;
	private final int height;
	private int trimLeft;
	private int trimRight;
	private int trimTop;
	private int trimBottom;

	public DrawableSprite(JeiSpriteUploader spriteUploader, class_2960 location, int width, int height) {
		this.spriteUploader = spriteUploader;
		this.location = location;
		this.width = width;
		this.height = height;
	}

	public DrawableSprite trim(int left, int right, int top, int bottom) {
		this.trimLeft = left;
		this.trimRight = right;
		this.trimTop = top;
		this.trimBottom = bottom;
		return this;
	}

	@Override
	public int getWidth() {
		return width;
	}

	@Override
	public int getHeight() {
		return height;
	}

	@Override
	public void draw(class_332 guiGraphics, int xOffset, int yOffset) {
		draw(guiGraphics, xOffset, yOffset, 0, 0, 0, 0);
	}

	@Override
	public void draw(class_332 guiGraphics, int xOffset, int yOffset, int maskTop, int maskBottom, int maskLeft, int maskRight) {
		class_1058 sprite = spriteUploader.method_18667(location);
		int textureWidth = this.width;
		int textureHeight = this.height;

		class_1921 rendertype = class_1921.method_62277(Constants.LOCATION_JEI_GUI_TEXTURE_ATLAS);
		class_4588 bufferBuilder = class_310.method_1551().method_22940().method_23000().getBuffer(rendertype);

		maskTop += trimTop;
		maskBottom += trimBottom;
		maskLeft += trimLeft;
		maskRight += trimRight;

		int x = xOffset + maskLeft;
		int y = yOffset + maskTop;
		int width = textureWidth - maskRight - maskLeft;
		int height = textureHeight - maskBottom - maskTop;
		float uSize = sprite.method_4577() - sprite.method_4594();
		float vSize = sprite.method_4575() - sprite.method_4593();

		float minU = sprite.method_4594() + uSize * (maskLeft / (float) textureWidth);
		float minV = sprite.method_4593() + vSize * (maskTop / (float) textureHeight);
		float maxU = sprite.method_4577() - uSize * (maskRight / (float) textureWidth);
		float maxV = sprite.method_4575() - vSize * (maskBottom / (float) textureHeight);

		Matrix4f matrix = guiGraphics.method_51448().method_23760().method_23761();
		bufferBuilder.method_22918(matrix, x, y + height, 0)
			.method_1336(255, 255, 255, 255)
			.method_22913(minU, maxV);
		bufferBuilder.method_22918(matrix, x + width, y + height, 0)
			.method_1336(255, 255, 255, 255)
			.method_22913(maxU, maxV);
		bufferBuilder.method_22918(matrix, x + width, y, 0)
			.method_1336(255, 255, 255, 255)
			.method_22913(maxU, minV);
		bufferBuilder.method_22918(matrix, x, y, 0)
			.method_1336(255, 255, 255, 255)
			.method_22913(minU, minV);
	}
}
