/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.recipes;

import mezz.jei.api.gui.IRecipeLayoutDrawable;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.common.Internal;
import mezz.jei.common.gui.JeiTooltip;
import mezz.jei.common.gui.textures.Textures;
import mezz.jei.gui.bookmarks.BookmarkList;
import mezz.jei.gui.bookmarks.IBookmark;
import mezz.jei.gui.elements.GuiIconToggleButton;
import mezz.jei.gui.input.UserInput;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_5348;
import net.minecraft.class_768;
import org.jetbrains.annotations.Nullable;

public class RecipeBookmarkButton
extends GuiIconToggleButton {
    private final BookmarkList bookmarks;
    @Nullable
    private final IBookmark recipeBookmark;
    private boolean bookmarked;

    public static RecipeBookmarkButton create(IRecipeLayoutDrawable<?> recipeLayout, BookmarkList bookmarks, @Nullable IBookmark recipeBookmark) {
        Textures textures = Internal.getTextures();
        IDrawableStatic icon = textures.getRecipeBookmark();
        class_768 area = recipeLayout.getRecipeBookmarkButtonArea();
        class_768 layoutArea = recipeLayout.getRect();
        area.method_35778(area.method_3321() + layoutArea.method_3321());
        area.method_35781(area.method_3322() + layoutArea.method_3322());
        RecipeBookmarkButton recipeBookmarkButton = new RecipeBookmarkButton(icon, bookmarks, recipeBookmark);
        recipeBookmarkButton.updateBounds(area);
        return recipeBookmarkButton;
    }

    private RecipeBookmarkButton(IDrawable icon, BookmarkList bookmarks, @Nullable IBookmark recipeBookmark) {
        super(icon, icon);
        this.bookmarks = bookmarks;
        this.recipeBookmark = recipeBookmark;
        if (recipeBookmark == null) {
            this.button.field_22763 = false;
            this.button.field_22764 = false;
        }
        this.tick();
    }

    @Override
    protected void getTooltips(JeiTooltip tooltip) {
        if (this.recipeBookmark != null) {
            if (this.bookmarks.contains(this.recipeBookmark)) {
                tooltip.add((class_5348)class_2561.method_43471((String)"jei.tooltip.bookmarks.recipe.remove"));
            } else {
                tooltip.add((class_5348)class_2561.method_43471((String)"jei.tooltip.bookmarks.recipe.add"));
            }
        }
    }

    @Override
    public void tick() {
        this.bookmarked = this.recipeBookmark != null && this.bookmarks.contains(this.recipeBookmark);
    }

    @Override
    protected boolean isIconToggledOn() {
        return this.bookmarked;
    }

    @Override
    protected boolean onMouseClicked(UserInput input) {
        if (this.recipeBookmark != null) {
            if (!input.isSimulate()) {
                this.bookmarks.toggleBookmark(this.recipeBookmark);
            }
            return true;
        }
        return false;
    }

    @Override
    public void draw(class_332 guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.draw(guiGraphics, mouseX, mouseY, partialTicks);
        if (this.bookmarked) {
            guiGraphics.method_51739(class_1921.method_51784(), this.button.method_46426(), this.button.method_46427(), this.button.method_46426() + this.button.method_25368(), this.button.method_46427() + this.button.method_25364(), 0x1100FF00);
        }
    }
}

