package mezz.jei.library.plugins.vanilla.crafting;

import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.class_10289;
import net.minecraft.class_1860;
import net.minecraft.class_3859;
import net.minecraft.class_3861;
import net.minecraft.class_3862;
import net.minecraft.class_3920;
import net.minecraft.class_3955;
import net.minecraft.class_3956;
import net.minecraft.class_3975;
import net.minecraft.class_8059;
import net.minecraft.class_8786;
import net.minecraft.class_9695;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public final class VanillaRecipes {
	private final class_10289 syncedRecipes;

	public VanillaRecipes(class_10289 syncedRecipes) {
		this.syncedRecipes = syncedRecipes;
	}

	public CraftingRecipes getCraftingRecipes(IRecipeCategory<class_8786<class_3955>> craftingCategory) {
		CraftingRecipes result = new CraftingRecipes();

		Collection<class_8786<class_3955>> craftingRecipes = syncedRecipes.method_64698(class_3956.field_17545);
		for (class_8786<class_3955> recipe : craftingRecipes) {
			if (craftingCategory.isHandled(recipe)) {
				result.handled.add(recipe);
			} else {
				result.unhandled.add(recipe);
			}
		}
		return result;
	}

	public static class CraftingRecipes {
		private final List<class_8786<class_3955>> handled = new ArrayList<>();
		private final List<class_8786<class_3955>> unhandled = new ArrayList<>();

		public List<class_8786<class_3955>> getHandled() {
			return Collections.unmodifiableList(handled);
		}

		public List<class_8786<class_3955>> getUnhandled() {
			return Collections.unmodifiableList(unhandled);
		}
	}

	public List<class_8786<class_3975>> getStonecuttingRecipes(IRecipeCategory<class_8786<class_3975>> stonecuttingCategory) {
		return getHandledRecipes(syncedRecipes, class_3956.field_17641, stonecuttingCategory);
	}

	public List<class_8786<class_3861>> getFurnaceRecipes(IRecipeCategory<class_8786<class_3861>> furnaceCategory) {
		return getHandledRecipes(syncedRecipes, class_3956.field_17546, furnaceCategory);
	}

	public List<class_8786<class_3862>> getSmokingRecipes(IRecipeCategory<class_8786<class_3862>> smokingCategory) {
		return getHandledRecipes(syncedRecipes, class_3956.field_17548, smokingCategory);
	}

	public List<class_8786<class_3859>> getBlastingRecipes(IRecipeCategory<class_8786<class_3859>> blastingCategory) {
		return getHandledRecipes(syncedRecipes, class_3956.field_17547, blastingCategory);
	}

	public List<class_8786<class_3920>> getCampfireCookingRecipes(IRecipeCategory<class_8786<class_3920>> campfireCategory) {
		return getHandledRecipes(syncedRecipes, class_3956.field_17549, campfireCategory);
	}

	public List<class_8786<class_8059>> getSmithingRecipes(IRecipeCategory<class_8786<class_8059>> smithingCategory) {
		return getHandledRecipes(syncedRecipes, class_3956.field_25388, smithingCategory);
	}

	public static <C extends class_9695, T extends class_1860<C>> List<class_8786<T>> getHandledRecipes(
		class_10289 syncedRecipes,
		class_3956<T> recipeType,
		IRecipeCategory<class_8786<T>> recipeCategory
	) {
		return syncedRecipes.method_64698(recipeType)
			.stream()
			.filter(recipeCategory::isHandled)
			.toList();
	}

}
