package mezz.jei.library.plugins.vanilla.anvil;

import mezz.jei.api.gui.builder.IIngredientAcceptor;
import mezz.jei.api.gui.ingredient.IRecipeSlotDrawable;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.common.platform.IPlatformRecipeHelper;
import mezz.jei.library.util.RecipeUtil;
import net.minecraft.class_1799;
import net.minecraft.class_8062;
import net.minecraft.class_9697;
import java.util.List;

public class SmithingTrimCategoryExtension extends SmithingCategoryExtension<class_8062> {
	public SmithingTrimCategoryExtension(IPlatformRecipeHelper recipeHelper) {
		super(recipeHelper);
	}

	@Override
	public void onDisplayedIngredientsUpdate(
		class_8062 recipe,
		IRecipeSlotDrawable templateSlot,
		IRecipeSlotDrawable baseSlot,
		IRecipeSlotDrawable additionSlot,
		IRecipeSlotDrawable outputSlot,
		IFocusGroup focuses
	) {
		List<IFocus<?>> outputFocuses = focuses.getFocuses(RecipeIngredientRole.OUTPUT).toList();
		if (outputFocuses.isEmpty()) {
			class_1799 template = templateSlot.getDisplayedItemStack().orElse(class_1799.field_8037);
			class_1799 base = baseSlot.getDisplayedItemStack().orElse(class_1799.field_8037);
			class_1799 addition = additionSlot.getDisplayedItemStack().orElse(class_1799.field_8037);

			class_9697 recipeInput = new class_9697(template, base, addition);
			class_1799 output = RecipeUtil.assembleResultItem(recipeInput, recipe);
			IIngredientAcceptor<?> iIngredientAcceptor = outputSlot.createDisplayOverrides();
			iIngredientAcceptor.add(output);
		} else {
			class_1799 output = outputSlot.getDisplayedItemStack().orElse(class_1799.field_8037);
			class_1799 base = new class_1799(output.method_7909());
			class_1799 template = templateSlot.getDisplayedItemStack().orElse(class_1799.field_8037);
			class_1799 addition = additionSlot.getDisplayedItemStack().orElse(class_1799.field_8037);

			IIngredientAcceptor<?> iIngredientAcceptor1 = baseSlot.createDisplayOverrides();
			iIngredientAcceptor1.add(base);

			class_9697 recipeInput = new class_9697(template, base, addition);
			output = RecipeUtil.assembleResultItem(recipeInput, recipe);
			IIngredientAcceptor<?> iIngredientAcceptor = outputSlot.createDisplayOverrides();
			iIngredientAcceptor.add(output);
		}
	}
}
