package mezz.jei.library.plugins.vanilla.anvil;

import com.google.common.collect.Lists;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.recipe.vanilla.IJeiAnvilRecipe;
import mezz.jei.api.recipe.vanilla.IVanillaRecipeFactory;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.common.platform.IPlatformItemStackHelper;
import mezz.jei.common.platform.Services;
import mezz.jei.common.util.ErrorUtil;
import mezz.jei.common.util.RegistryUtil;
import mezz.jei.library.plugins.vanilla.ingredients.subtypes.EnchantedBookSubtypeInterpreter;
import mezz.jei.library.util.ResourceLocationUtil;
import net.minecraft.class_10302;
import net.minecraft.class_10352;
import net.minecraft.class_10363;
import net.minecraft.class_10630;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1706;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3489;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import net.minecraft.class_9304;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import java.util.List;
import java.util.Objects;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public final class AnvilRecipeMaker {
	private static final Logger LOGGER = LogManager.getLogger();
	private static final class_1799 ENCHANTED_BOOK = new class_1799(class_1802.field_8598);

	private AnvilRecipeMaker() {
	}

	public static List<IJeiAnvilRecipe> getAnvilRecipes(IVanillaRecipeFactory vanillaRecipeFactory, IIngredientManager ingredientManager) {
		IIngredientHelper<class_1799> ingredientHelper = ingredientManager.getIngredientHelper(VanillaTypes.ITEM_STACK);
		return Stream.concat(
				getRepairRecipes(vanillaRecipeFactory, ingredientHelper),
				getBookEnchantmentRecipes(ingredientManager)
			)
			.toList();
	}

	private static final class EnchantmentData {
		private final class_6880<class_1887> enchantment;
		private final List<class_1799> enchantedBooks;

		private EnchantmentData(class_6880<class_1887> enchantment) {
			this.enchantment = enchantment;
			this.enchantedBooks = getEnchantedBooks(enchantment);
		}

		public List<class_1799> getEnchantedBooks(class_1799 ingredient) {
			IPlatformItemStackHelper itemStackHelper = Services.PLATFORM.getItemStackHelper();
			var list = enchantedBooks.stream()
				.filter(enchantedBook -> itemStackHelper.isBookEnchantable(ingredient, enchantedBook))
				.toList();
			// avoid using copy of list if it contains the exact same items
			return list.size() == enchantedBooks.size() ? enchantedBooks : list;
		}

		private boolean canEnchant(IPlatformItemStackHelper itemStackHelper, class_1799 ingredient) {
			try {
				return itemStackHelper.canEnchant(enchantment, ingredient);
			} catch (RuntimeException e) {
				String stackInfo = ErrorUtil.getItemStackInfo(ingredient);
				LOGGER.error("Failed to check if ingredient can be enchanted: {}", stackInfo, e);
				return false;
			}
		}

		private static List<class_1799> getEnchantedBooks(class_6880<class_1887> enchantment) {
			return IntStream.rangeClosed(1, enchantment.comp_349().method_8183())
				.mapToObj(level -> {
					class_1799 bookEnchant = ENCHANTED_BOOK.method_7972();
					class_9304.class_9305 itemEnchantments = new class_9304.class_9305(class_1890.method_57532(bookEnchant));
					itemEnchantments.method_57547(enchantment, level);
					class_1890.method_57530(bookEnchant, itemEnchantments.method_57549());
					return bookEnchant;
				})
				.toList();
		}
	}

	private static Stream<IJeiAnvilRecipe> getBookEnchantmentRecipes(
		IIngredientManager ingredientManager
	) {
		class_2378<class_1887> registry = RegistryUtil.getRegistry(class_7924.field_41265);
		List<EnchantmentData> enchantmentDatas = registry.method_42017()
			.map(EnchantmentData::new)
			.toList();

		return ingredientManager.getAllItemStacks()
			.stream()
			.filter(class_1799::method_7923)
			.flatMap(ingredient -> getBookEnchantmentRecipes(enchantmentDatas, ingredient));
	}

	private static Stream<IJeiAnvilRecipe> getBookEnchantmentRecipes(
		List<EnchantmentData> enchantmentDatas,
		class_1799 ingredient
	) {
		IPlatformItemStackHelper itemStackHelper = Services.PLATFORM.getItemStackHelper();
		var ingredientSingletonList = List.of(ingredient);
		return enchantmentDatas.stream()
			.filter(data -> data.canEnchant(itemStackHelper, ingredient))
			.map(data -> data.getEnchantedBooks(ingredient))
			.filter(enchantedBooks -> !enchantedBooks.isEmpty())
			.map(enchantedBooks -> {
				List<class_1799> outputs = getEnchantedIngredients(ingredient, enchantedBooks);
				// All lists given here are immutable, and we want to keep the transforming list from outputs,
				// so we call the AnvilRecipe constructor directly
				return new AnvilRecipe(ingredientSingletonList, enchantedBooks, outputs, null);
			});
	}

	private static List<class_1799> getEnchantedIngredients(class_1799 ingredient, List<class_1799> enchantedBooks) {
		return Lists.transform(enchantedBooks, enchantedBook -> getEnchantedIngredient(ingredient, enchantedBook));
	}

	private static class_1799 getEnchantedIngredient(class_1799 ingredient, class_1799 enchantedBook) {
		class_1799 enchantedIngredient = ingredient.method_7972();
		class_9304 enchantments = class_1890.method_57532(enchantedBook);
		class_1890.method_57530(enchantedIngredient, enchantments);
		return enchantedIngredient;
	}

	private static class RepairData {
		private final class_10302 repairIngredient;
		private final List<class_1799> repairables;

		public RepairData(class_6862<class_1792> repairTag, class_1799... repairables) {
			this.repairIngredient = new class_10302.class_10311(repairTag);
			this.repairables = List.of(repairables);
		}

		public RepairData(class_10302 repairIngredient, class_1799... repairables) {
			this.repairIngredient = repairIngredient;
			this.repairables = List.of(repairables);
		}

		public class_10302 getRepairIngredient() {
			return repairIngredient;
		}

		public List<class_1799> getRepairables() {
			return repairables;
		}
	}

	private static Stream<RepairData> getRepairData() {
		return Stream.of(
			new RepairData(class_3489.field_52381,
				new class_1799(class_1802.field_8091),
				new class_1799(class_1802.field_8647),
				new class_1799(class_1802.field_8406),
				new class_1799(class_1802.field_8876),
				new class_1799(class_1802.field_8167)
			),
			new RepairData(class_3489.field_15537,
				new class_1799(class_1802.field_8255)
			),
			new RepairData(class_3489.field_23802,
				new class_1799(class_1802.field_8528),
				new class_1799(class_1802.field_8387),
				new class_1799(class_1802.field_8062),
				new class_1799(class_1802.field_8776),
				new class_1799(class_1802.field_8431)
			),
			new RepairData(class_3489.field_54059,
				new class_1799(class_1802.field_8267),
				new class_1799(class_1802.field_8577),
				new class_1799(class_1802.field_8570),
				new class_1799(class_1802.field_8370)
			),
			new RepairData(class_3489.field_52382,
				new class_1799(class_1802.field_8371),
				new class_1799(class_1802.field_8403),
				new class_1799(class_1802.field_8475),
				new class_1799(class_1802.field_8699),
				new class_1799(class_1802.field_8609)
			),
			new RepairData(class_3489.field_54061,
				new class_1799(class_1802.field_8743),
				new class_1799(class_1802.field_8523),
				new class_1799(class_1802.field_8396),
				new class_1799(class_1802.field_8660)
			),
			new RepairData(class_3489.field_54060,
				new class_1799(class_1802.field_8283),
				new class_1799(class_1802.field_8873),
				new class_1799(class_1802.field_8218),
				new class_1799(class_1802.field_8313)
			),
			new RepairData(class_3489.field_52385,
				new class_1799(class_1802.field_8845),
				new class_1799(class_1802.field_8335),
				new class_1799(class_1802.field_8825),
				new class_1799(class_1802.field_8322),
				new class_1799(class_1802.field_8303)
			),
			new RepairData(class_3489.field_54062,
				new class_1799(class_1802.field_8862),
				new class_1799(class_1802.field_8678),
				new class_1799(class_1802.field_8416),
				new class_1799(class_1802.field_8753)
			),
			new RepairData(class_3489.field_52386,
				new class_1799(class_1802.field_8802),
				new class_1799(class_1802.field_8377),
				new class_1799(class_1802.field_8556),
				new class_1799(class_1802.field_8250),
				new class_1799(class_1802.field_8527)
			),
			new RepairData(class_3489.field_54063,
				new class_1799(class_1802.field_8805),
				new class_1799(class_1802.field_8058),
				new class_1799(class_1802.field_8348),
				new class_1799(class_1802.field_8285)
			),
			new RepairData(class_3489.field_52387,
				new class_1799(class_1802.field_22022),
				new class_1799(class_1802.field_22025),
				new class_1799(class_1802.field_22026),
				new class_1799(class_1802.field_22023),
				new class_1799(class_1802.field_22024)
			),
			new RepairData(class_3489.field_54064,
				new class_1799(class_1802.field_22030),
				new class_1799(class_1802.field_22027),
				new class_1799(class_1802.field_22029),
				new class_1799(class_1802.field_22028)
			),
			new RepairData(class_1856.method_8101(class_1802.field_8614).method_64673(),
				new class_1799(class_1802.field_8833)
			),
			new RepairData(class_3489.field_54065,
				new class_1799(class_1802.field_8090)
			)
		);
	}

	private static Stream<IJeiAnvilRecipe> getRepairRecipes(
		IVanillaRecipeFactory vanillaRecipeFactory,
		IIngredientHelper<class_1799> ingredientHelper
	) {
		return getRepairData()
			.flatMap(repairData -> getRepairRecipes(repairData, vanillaRecipeFactory, ingredientHelper));
	}

	private static Stream<IJeiAnvilRecipe> getRepairRecipes(
		RepairData repairData,
		IVanillaRecipeFactory vanillaRecipeFactory,
		IIngredientHelper<class_1799> ingredientHelper
	) {
		class_10302 repairIngredient = repairData.getRepairIngredient();
		List<class_1799> repairables = repairData.getRepairables();

		class_310 minecraft = class_310.method_1551();
		class_10352 contextmap = class_10363.method_65008(Objects.requireNonNull(minecraft.field_1687));
		List<class_1799> repairMaterials = repairIngredient.method_64738(contextmap);

		return repairables.stream()
			.mapMulti((itemStack, consumer) -> {
				String uid = EnchantedBookSubtypeInterpreter.INSTANCE.getStringName(itemStack);
				String ingredientIdPath = ResourceLocationUtil.sanitizePath(uid);
				String itemModId = ingredientHelper.getResourceLocation(itemStack).method_12836();

				class_1799 damagedThreeQuarters = itemStack.method_7972();
				damagedThreeQuarters.method_7974(damagedThreeQuarters.method_7936() * 3 / 4);
				class_1799 damagedHalf = itemStack.method_7972();
				damagedHalf.method_7974(damagedHalf.method_7936() / 2);

				var damagedThreeQuartersSingletonList = List.of(damagedThreeQuarters);

				IJeiAnvilRecipe repairWithSame = vanillaRecipeFactory.createAnvilRecipe(
					damagedThreeQuartersSingletonList,
					damagedThreeQuartersSingletonList,
					List.of(damagedHalf),
					class_2960.method_60655(itemModId, "self_repair." + ingredientIdPath)
				);
				consumer.accept(repairWithSame);

				if (!repairMaterials.isEmpty()) {
					class_1799 damagedFully = itemStack.method_7972();
					damagedFully.method_7974(damagedFully.method_7936());
					IJeiAnvilRecipe repairWithMaterial = vanillaRecipeFactory.createAnvilRecipe(
						List.of(damagedFully),
						repairMaterials,
						damagedThreeQuartersSingletonList,
						class_2960.method_60655(itemModId, "materials_repair." + ingredientIdPath)
					);
					consumer.accept(repairWithMaterial);
				}
			});
	}

	public static int findLevelsCost(class_1799 leftStack, class_1799 rightStack) {
		class_1657 player = class_310.method_1551().field_1724;
		if (player == null) {
			return -1;
		}
		class_1661 fakeInventory = new class_1661(player, new class_10630());
		try {
			class_1706 repair = new class_1706(0, fakeInventory);
			repair.field_7761.get(0).method_7673(leftStack);
			repair.field_7761.get(1).method_7673(rightStack);
			return repair.method_17369();
		} catch (RuntimeException e) {
			String left = ErrorUtil.getItemStackInfo(leftStack);
			String right = ErrorUtil.getItemStackInfo(rightStack);
			LOGGER.error("Could not get anvil level cost for: ({} and {}).", left, right, e);
			return -1;
		}
	}
}
