package mezz.jei.gui.recipes;

import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.helpers.IModIdHelper;
import mezz.jei.api.recipe.IRecipeManager;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.common.Internal;
import mezz.jei.common.gui.JeiTooltip;
import mezz.jei.common.input.IInternalKeyMappings;
import mezz.jei.gui.input.IUserInputHandler;
import mezz.jei.gui.input.UserInput;
import net.minecraft.class_1109;
import net.minecraft.class_1144;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3417;
import net.minecraft.class_437;
import java.util.Optional;

public class RecipeCategoryTab extends RecipeGuiTab {
	private final IRecipeGuiLogic logic;
	private final IRecipeCategory<?> category;
	private final IRecipeManager recipeManager;
	private final IGuiHelper guiHelper;

	public RecipeCategoryTab(
		IRecipeGuiLogic logic,
		IRecipeCategory<?> category,
		int x,
		int y,
		IRecipeManager recipeManager,
		IGuiHelper guiHelper
	) {
		super(x, y);
		this.logic = logic;
		this.category = category;
		this.recipeManager = recipeManager;
		this.guiHelper = guiHelper;
	}

	@Override
	public Optional<IUserInputHandler> handleUserInput(class_437 screen, UserInput input, IInternalKeyMappings keyBindings) {
		if (!isMouseOver(input.getMouseX(), input.getMouseY())) {
			return Optional.empty();
		}
		if (input.is(keyBindings.getLeftClick())) {
			if (!input.isSimulate()) {
				logic.setRecipeCategory(category);
				class_1144 soundHandler = class_310.method_1551().method_1483();
				soundHandler.method_4873(class_1109.method_47978(class_3417.field_15015, 1.0F));
			}
			return Optional.of(this);
		}
		return Optional.empty();
	}

	@Override
	public void draw(boolean selected, class_332 guiGraphics, int mouseX, int mouseY) {
		super.draw(selected, guiGraphics, mouseX, mouseY);

		IDrawable icon = RecipeCategoryIconUtil.create(category, recipeManager, guiHelper);
		int iconX = area.x() + (TAB_WIDTH - icon.getWidth()) / 2;
		int iconY = area.y() + (TAB_HEIGHT - icon.getHeight()) / 2;
		icon.draw(guiGraphics, iconX, iconY);
	}

	@Override
	public boolean isSelected(IRecipeCategory<?> selectedCategory) {
		return category.getRecipeType().equals(selectedCategory.getRecipeType());
	}

	@Override
	public JeiTooltip getTooltip() {
		JeiTooltip tooltip = new JeiTooltip();
		class_2561 title = category.getTitle();
		//noinspection ConstantConditions
		if (title != null) {
			tooltip.add(title);
		}

		class_2960 uid = category.getRecipeType().getUid();
		String modId = uid.method_12836();
		IModIdHelper modIdHelper = Internal.getJeiRuntime().getJeiHelpers().getModIdHelper();
		if (modIdHelper.isDisplayingModNameEnabled()) {
			String modName = modIdHelper.getFormattedModNameForModId(modId);
			tooltip.add(class_2561.method_43470(modName));
		}
		return tooltip;
	}
}
