package mezz.jei.common.gui.elements;

import mezz.jei.api.gui.drawable.IDrawableStatic;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4588;
import org.joml.Matrix4f;

public class DrawableResource implements IDrawableStatic {

	private final class_2960 resourceLocation;
	private final int textureWidth;
	private final int textureHeight;

	private final int u;
	private final int v;
	private final int width;
	private final int height;
	private final int paddingTop;
	private final int paddingBottom;
	private final int paddingLeft;
	private final int paddingRight;

	public DrawableResource(class_2960 resourceLocation, int u, int v, int width, int height, int paddingTop, int paddingBottom, int paddingLeft, int paddingRight, int textureWidth, int textureHeight) {
		this.resourceLocation = resourceLocation;
		this.textureWidth = textureWidth;
		this.textureHeight = textureHeight;

		this.u = u;
		this.v = v;
		this.width = width;
		this.height = height;

		this.paddingTop = paddingTop;
		this.paddingBottom = paddingBottom;
		this.paddingLeft = paddingLeft;
		this.paddingRight = paddingRight;
	}

	@Override
	public int getWidth() {
		return width + paddingLeft + paddingRight;
	}

	@Override
	public int getHeight() {
		return height + paddingTop + paddingBottom;
	}

	@Override
	public void draw(class_332 guiGraphics, int xOffset, int yOffset) {
		draw(guiGraphics, xOffset, yOffset, 0, 0, 0, 0);
	}

	@Override
	public void draw(class_332 guiGraphics, int xOffset, int yOffset, int maskTop, int maskBottom, int maskLeft, int maskRight) {
		class_1921 rendertype = class_1921.method_62277(this.resourceLocation);
		class_4588 bufferBuilder = class_310.method_1551().method_22940().method_23000().getBuffer(rendertype);

		int x = xOffset + this.paddingLeft + maskLeft;
		int y = yOffset + this.paddingTop + maskTop;
		int u = this.u + maskLeft;
		int v = this.v + maskTop;
		int width = this.width - maskRight - maskLeft;
		int height = this.height - maskBottom - maskTop;
		float f = 1.0F / this.textureWidth;
		float f1 = 1.0F / this.textureHeight;

		Matrix4f matrix = guiGraphics.method_51448().method_23760().method_23761();
		bufferBuilder.method_22918(matrix, x, y + height, 0)
			.method_1336(255, 255, 255, 255)
			.method_22913(u * f, (v + (float) height) * f1);
		bufferBuilder.method_22918(matrix, x + width, y + height, 0)
			.method_1336(255, 255, 255, 255)
			.method_22913((u + (float) width) * f, (v + (float) height) * f1);
		bufferBuilder.method_22918(matrix, x + width, y, 0)
			.method_1336(255, 255, 255, 255)
			.method_22913((u + (float) width) * f, v * f1);
		bufferBuilder.method_22918(matrix, x, y, 0)
			.method_1336(255, 255, 255, 255)
			.method_22913(u * f, v * f1);
	}
}
