package mezz.jei.api.recipe.category;

import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.recipe.types.IRecipeType;
import net.minecraft.class_2561;

/**
 * Simple abstract implementation of {@link IRecipeCategory} to help simplify creating recipe categories.
 * @since 19.19.0
 */
public abstract class AbstractRecipeCategory<T> implements IRecipeCategory<T> {
	private final IRecipeType<T> recipeType;
	private final class_2561 title;
	private final IDrawable icon;
	private final int width;
	private final int height;

	/**
	 * @since 19.19.0
	 */
	public AbstractRecipeCategory(IRecipeType<T> recipeType, class_2561 title, IDrawable icon, int width, int height) {
		this.recipeType = recipeType;
		this.title = title;
		this.icon = icon;
		this.width = width;
		this.height = height;
	}

	@Override
	public final IRecipeType<T> getRecipeType() {
		return recipeType;
	}

	@Override
	public final class_2561 getTitle() {
		return title;
	}

	@Override
	public final IDrawable getIcon() {
		return icon;
	}

	@Override
	public final int getWidth() {
		return width;
	}

	@Override
	public final int getHeight() {
		return height;
	}
}
