package mezz.jei.api.registration;

import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.types.IRecipeType;
import mezz.jei.api.runtime.IIngredientManager;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import java.util.List;

public interface IRecipeCatalystRegistration {
	/**
	 * The {@link IIngredientManager} has some useful functions related to recipe ingredients.
	 * @since 9.5.5
	 */
	IIngredientManager getIngredientManager();

	/**
	 * {@link IJeiHelpers} provides helpers and tools for addon mods.
	 * @since 11.4.0
	 */
	IJeiHelpers getJeiHelpers();

	/**
	 * Add an association between {@link class_1935}s and what it can craft.
	 * (i.e. Furnace Item can craft Smelting and Fuel Recipes)
	 * Allows players to see what ingredient they need to craft in order to make recipes from a recipe category.
	 *
	 * @param recipeType the types of recipe that the ingredient is a catalyst for
	 * @param ingredients the {@link class_1935}s that can craft recipes (like a furnace or crafting table)
	 *
	 * @see #addCraftingStation(IRecipeType, class_1799...) to add {@link class_1799} catalysts.
	 * @see #addCraftingStations(IRecipeType, IIngredientType, List) to add non-{@link class_1935} catalysts.
	 *
	 * @since 20.0.0
	 */
	void addCraftingStation(IRecipeType<?> recipeType, class_1935... ingredients);

	/**
	 * Add an association between an {@link class_1799} and what it can craft.
	 * (i.e. Furnace ItemStack can craft Smelting and Fuel Recipes)
	 * Allows players to see what ingredient they need to craft in order to make recipes from a recipe category.
	 *
	 * @param ingredients the {@link class_1799}s that can craft recipes (like a furnace or crafting table)
	 * @param recipeType  the type of recipe that the ingredients are a catalyst for
	 *
	 * @see #addRecipeCatalysts(IRecipeType, IIngredientType, List) to add non-{@link class_1799} catalysts.
	 *
	 * @since 20.0.0
	 */
	default void addCraftingStation(IRecipeType<?> recipeType, class_1799... ingredients) {
		addCraftingStations(recipeType, VanillaTypes.ITEM_STACK, List.of(ingredients));
	}

	/**
	 * Add an association between ingredients and what it can craft. (i.e. Furnace ItemStack -> Smelting and Fuel Recipes)
	 * Allows players to see what ingredients they need to craft in order to make recipes from a recipe category.
	 *
	 * @param recipeType     the type of recipe that the ingredients are a catalyst for
	 * @param ingredientType the type of the ingredient
	 * @param ingredient     the ingredient that can craft recipes (like a furnace or crafting table)
	 * @since 20.0.0
	 */
	<T> void addCraftingStation(IRecipeType<?> recipeType, IIngredientType<T> ingredientType, T ingredient);

	/**
	 * Add an association between ingredients and what it can craft. (i.e. Furnace ItemStack -> Smelting and Fuel Recipes)
	 * Allows players to see what ingredients they need to craft in order to make recipes from a recipe category.
	 *
	 * @param recipeType     the type of recipe that the ingredients are a catalyst for
	 * @param ingredientType the type of the ingredient
	 * @param ingredients    the ingredients that can craft recipes (like a furnace or crafting table)
	 * @since 20.0.0
	 */
	<T> void addCraftingStations(IRecipeType<?> recipeType, IIngredientType<T> ingredientType, List<T> ingredients);

	/**
	 * Add an association between {@link class_1935}s and what it can craft.
	 * (i.e. Furnace Item can craft Smelting and Fuel Recipes)
	 * Allows players to see what ingredient they need to craft in order to make recipes from a recipe category.
	 *
	 * @param recipeType the types of recipe that the ingredient is a catalyst for
	 * @param ingredients the {@link class_1935}s that can craft recipes (like a furnace or crafting table)
	 *
	 * @see #addRecipeCatalysts(IRecipeType, class_1799...) to add {@link class_1799} catalysts.
	 * @see #addRecipeCatalysts(IRecipeType, IIngredientType, List) to add non-{@link class_1935} catalysts.
	 *
	 * @since 19.19.2
	 * @deprecated use {@link #addCraftingStation(IRecipeType, class_1935...)}
	 */
	@Deprecated(forRemoval = true, since = "20.0.0")
	default void addRecipeCatalysts(IRecipeType<?> recipeType, class_1935... ingredients) {
		addCraftingStation(recipeType, ingredients);
	}

	/**
	 * Add an association between an {@link class_1799} and what it can craft.
	 * (i.e. Furnace ItemStack can craft Smelting and Fuel Recipes)
	 * Allows players to see what ingredient they need to craft in order to make recipes from a recipe category.
	 *
	 * @param ingredients the {@link class_1799}s that can craft recipes (like a furnace or crafting table)
	 * @param recipeType  the type of recipe that the ingredients are a catalyst for
	 *
	 * @see #addRecipeCatalysts(IRecipeType, IIngredientType, List) to add non-{@link class_1799} catalysts.
	 *
	 * @since 19.19.2
	 * @deprecated use {@link #addCraftingStation(IRecipeType, class_1799...)}
	 */
	@Deprecated(forRemoval = true, since = "20.0.0")
	default void addRecipeCatalysts(IRecipeType<?> recipeType, class_1799... ingredients) {
		addCraftingStation(recipeType, ingredients);
	}

	/**
	 * Add an association between ingredients and what it can craft. (i.e. Furnace ItemStack -> Smelting and Fuel Recipes)
	 * Allows players to see what ingredients they need to craft in order to make recipes from a recipe category.
	 *
	 * @param recipeType     the type of recipe that the ingredients are a catalyst for
	 * @param ingredientType the type of the ingredient
	 * @param ingredients    the ingredients that can craft recipes (like a furnace or crafting table)
	 * @since 19.19.2
	 * @deprecated use {@link #addCraftingStations(IRecipeType, IIngredientType, List)}
	 */
	@Deprecated(forRemoval = true, since = "20.0.0")
	default <T> void addRecipeCatalysts(IRecipeType<?> recipeType, IIngredientType<T> ingredientType, List<T> ingredients) {
		addCraftingStations(recipeType, ingredientType, ingredients);
	}

	/**
	 * Add an association between an {@link class_1799} and what it can craft.
	 * (i.e. Furnace ItemStack can craft Smelting and Fuel Recipes)
	 * Allows players to see what ingredient they need to craft in order to make recipes from a recipe category.
	 *
	 * @param itemLike    the {@link class_1935} that can craft recipes (like a furnace or crafting table)
	 * @param recipeTypes the types of recipe that the ingredient is a catalyst for
	 *
	 * @see #addRecipeCatalyst(class_1799, IRecipeType...) to add {@link class_1799} catalysts.
	 * @see #addRecipeCatalyst(IIngredientType, Object, IRecipeType...) to add non-{@link class_1935} catalysts.
	 *
	 * @since 19.18.2
	 * @deprecated use {@link #addCraftingStation(IRecipeType, class_1935...)}
	 */
	@Deprecated(forRemoval = true, since = "20.0.0")
	default void addRecipeCatalyst(class_1935 itemLike, IRecipeType<?>... recipeTypes) {
		addRecipeCatalyst(VanillaTypes.ITEM_STACK, itemLike.method_8389().method_7854(), recipeTypes);
	}

	/**
	 * Add an association between an {@link class_1799} and what it can craft.
	 * (i.e. Furnace ItemStack can craft Smelting and Fuel Recipes)
	 * Allows players to see what ingredient they need to craft in order to make recipes from a recipe category.
	 *
	 * @param ingredient  the {@link class_1799} that can craft recipes (like a furnace or crafting table)
	 * @param recipeTypes the types of recipe that the ingredient is a catalyst for
	 * @see #addRecipeCatalyst(IIngredientType, Object, IRecipeType...) to add non-{@link class_1799} catalysts.
	 *
	 * @since 9.5.0
	 * @deprecated use {@link #addCraftingStation(IRecipeType, class_1799...)}
	 */
	@SuppressWarnings("DeprecatedIsStillUsed")
	@Deprecated(forRemoval = true, since = "20.0.0")
	default void addRecipeCatalyst(class_1799 ingredient, IRecipeType<?>... recipeTypes) {
		addRecipeCatalyst(VanillaTypes.ITEM_STACK, ingredient, recipeTypes);
	}

	/**
	 * Add an association between an ingredient and what it can craft. (i.e. Furnace ItemStack -> Smelting and Fuel Recipes)
	 * Allows players to see what ingredient they need to craft in order to make recipes from a recipe category.
	 *
	 * @param ingredientType the type of the ingredient
	 * @param ingredient     the ingredient that can craft recipes (like a furnace or crafting table)
	 * @param recipeTypes    the types of recipe that the ingredient is a catalyst for
	 * @since 9.5.0
	 * @deprecated use {@link #addCraftingStation(IRecipeType, IIngredientType, T)}
	 */
	@Deprecated(forRemoval = true, since = "20.0.0")
	<T> void addRecipeCatalyst(IIngredientType<T> ingredientType, T ingredient, IRecipeType<?>... recipeTypes);
}
