/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.elements;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Optional;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.common.Internal;
import mezz.jei.common.gui.elements.DrawableNineSliceTexture;
import mezz.jei.common.gui.textures.Textures;
import mezz.jei.common.input.IInternalKeyMappings;
import mezz.jei.common.util.ImmutableRect2i;
import mezz.jei.gui.input.IUserInputHandler;
import mezz.jei.gui.input.UserInput;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.CommonComponents;

public class GuiIconButton
extends Button {
    private IDrawable icon;
    private boolean pressed = false;
    private boolean forcePressed = false;

    public GuiIconButton(int x, int y, int width, int height, IDrawable icon, Button.OnPress pressable) {
        super(x, y, width, height, CommonComponents.EMPTY, pressable, Button.DEFAULT_NARRATION);
        this.icon = icon;
    }

    public GuiIconButton(IDrawable icon, Button.OnPress pressable) {
        super(0, 0, 0, 0, CommonComponents.EMPTY, pressable, Button.DEFAULT_NARRATION);
        this.icon = icon;
    }

    public void updateBounds(Rect2i area) {
        this.setX(area.getX());
        this.setY(area.getY());
        this.width = area.getWidth();
        this.height = area.getHeight();
    }

    public void updateBounds(ImmutableRect2i area) {
        this.setX(area.getX());
        this.setY(area.getY());
        this.width = area.getWidth();
        this.height = area.getHeight();
    }

    public void setHeight(int value) {
        this.height = value;
    }

    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        boolean hovered = mouseX >= this.getX() && mouseY >= this.getY() && mouseX < this.getX() + this.width && mouseY < this.getY() + this.height;
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        Textures textures = Internal.getTextures();
        boolean isPressed = this.pressed || this.forcePressed;
        DrawableNineSliceTexture texture = textures.getButtonForState(isPressed, this.active, hovered);
        texture.draw(guiGraphics, this.getX(), this.getY(), this.width, this.height);
        int color = -2039584;
        if (!this.active) {
            color = -6250336;
        } else if (hovered) {
            color = -1;
        }
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float blue = (float)(color >> 8 & 0xFF) / 255.0f;
        float green = (float)(color & 0xFF) / 255.0f;
        float alpha = (float)(color >> 24 & 0xFF) / 255.0f;
        RenderSystem.setShaderColor((float)red, (float)blue, (float)green, (float)alpha);
        double xOffset = (double)this.getX() + (double)(this.width - this.icon.getWidth()) / 2.0;
        double yOffset = (double)this.getY() + (double)(this.height - this.icon.getHeight()) / 2.0;
        if (isPressed) {
            xOffset += 0.5;
            yOffset += 0.5;
        }
        PoseStack poseStack = guiGraphics.pose();
        poseStack.pushPose();
        poseStack.translate(xOffset, yOffset, 0.0);
        this.icon.draw(guiGraphics);
        poseStack.popPose();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public IUserInputHandler createInputHandler() {
        return new UserInputHandler(this);
    }

    public void setForcePressed(boolean forcePressed) {
        this.forcePressed = forcePressed;
    }

    public ImmutableRect2i getArea() {
        return new ImmutableRect2i(this.getX(), this.getY(), this.width, this.height);
    }

    public void setIcon(IDrawable icon) {
        this.icon = icon;
    }

    private class UserInputHandler
    implements IUserInputHandler {
        private final GuiIconButton button;

        public UserInputHandler(GuiIconButton button) {
            this.button = button;
        }

        @Override
        public Optional<IUserInputHandler> handleUserInput(Screen screen, UserInput input, IInternalKeyMappings keyBindings) {
            this.button.pressed = false;
            double mouseX = input.getMouseX();
            double mouseY = input.getMouseY();
            if (!(this.button.active && this.button.visible && GuiIconButton.this.isMouseOver(mouseX, mouseY))) {
                return Optional.empty();
            }
            if (!this.button.isValidClickButton(input.getKey().getValue())) {
                return Optional.empty();
            }
            if (!input.isSimulate()) {
                this.button.playDownSound(Minecraft.getInstance().getSoundManager());
                this.button.onClick(mouseX, mouseY);
            } else {
                this.button.pressed = true;
            }
            return Optional.of(this);
        }

        @Override
        public void unfocus() {
            this.button.pressed = false;
        }
    }
}

