/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.ingredients;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import mezz.jei.api.gui.builder.ITooltipBuilder;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.common.util.StringUtil;
import mezz.jei.common.util.Translator;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.inventory.tooltip.TooltipComponent;

public class ListElementInfoTooltip
implements ITooltipBuilder {
    private final List<FormattedText> tooltip = new ArrayList<FormattedText>();

    public void add(FormattedText component) {
        this.tooltip.add(component);
    }

    public void addAll(Collection<? extends FormattedText> components) {
        this.tooltip.addAll(components);
    }

    public void add(TooltipComponent component) {
    }

    public void setIngredient(ITypedIngredient<?> typedIngredient) {
    }

    public void clear() {
        this.tooltip.clear();
    }

    public List<Component> toLegacyToComponents() {
        return this.tooltip.stream().mapMulti((f, consumer) -> {
            if (f instanceof Component) {
                Component c = (Component)f;
                consumer.accept(c);
            }
        }).collect(Collectors.toCollection(ArrayList::new));
    }

    public void removeAll(List<Component> components) {
        for (Component component : components) {
            this.tooltip.remove(component);
        }
    }

    public Set<String> getStrings() {
        HashSet<String> result = new HashSet<String>();
        for (FormattedText component : this.tooltip) {
            String string = component.getString();
            string = StringUtil.removeChatFormatting((String)string);
            string = Translator.toLowercaseWithLocale((String)string);
            String[] strings = string.split(" ");
            Collections.addAll(result, strings);
        }
        return result;
    }
}

