/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.recipes;

import com.mojang.blaze3d.platform.InputConstants;
import java.util.Optional;
import mezz.jei.api.gui.IRecipeLayoutDrawable;
import mezz.jei.api.gui.handlers.IGuiProperties;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.common.Internal;
import mezz.jei.common.input.IInternalKeyMappings;
import mezz.jei.gui.bookmarks.BookmarkList;
import mezz.jei.gui.bookmarks.RecipeBookmark;
import mezz.jei.gui.input.IUserInputHandler;
import mezz.jei.gui.input.UserInput;
import mezz.jei.gui.input.handlers.CombinedInputHandler;
import mezz.jei.gui.recipes.IRecipeLayoutWithButtons;
import mezz.jei.gui.recipes.RecipeBookmarkButton;
import mezz.jei.gui.recipes.RecipeTransferButton;
import mezz.jei.gui.recipes.RecipesGui;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.Identifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import org.jetbrains.annotations.Nullable;

public final class RecipeLayoutWithButtons<R>
implements IRecipeLayoutWithButtons<R> {
    private final IRecipeLayoutDrawable<R> recipeLayout;
    private final RecipeTransferButton transferButton;
    private final RecipeBookmarkButton bookmarkButton;

    public static <T> IRecipeLayoutWithButtons<T> create(IRecipeLayoutDrawable<T> recipeLayoutDrawable, @Nullable RecipeBookmark<?, ?> recipeBookmark, BookmarkList bookmarks, RecipesGui recipesGui, @Nullable AbstractContainerMenu container) {
        Minecraft minecraft = Minecraft.getInstance();
        LocalPlayer player = minecraft.player;
        RecipeTransferButton transferButton = RecipeTransferButton.create(recipeLayoutDrawable, recipesGui::onClose, container, (Player)player);
        RecipeBookmarkButton bookmarkButton = RecipeBookmarkButton.create(recipeLayoutDrawable, bookmarks, recipeBookmark);
        return new RecipeLayoutWithButtons<T>(recipeLayoutDrawable, transferButton, bookmarkButton);
    }

    private RecipeLayoutWithButtons(IRecipeLayoutDrawable<R> recipeLayout, RecipeTransferButton transferButton, RecipeBookmarkButton bookmarkButton) {
        this.recipeLayout = recipeLayout;
        this.transferButton = transferButton;
        this.bookmarkButton = bookmarkButton;
    }

    @Override
    public void draw(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.recipeLayout.drawRecipe(guiGraphics, mouseX, mouseY);
        this.transferButton.draw(guiGraphics, mouseX, mouseY, partialTicks);
        this.bookmarkButton.draw(guiGraphics, mouseX, mouseY, partialTicks);
    }

    @Override
    public void updateBounds(int recipeXOffset, int recipeYOffset) {
        Rect2i rectWithBorder = this.recipeLayout.getRectWithBorder();
        Rect2i rect = this.recipeLayout.getRect();
        this.recipeLayout.setPosition(recipeXOffset - rectWithBorder.getX() + rect.getX(), recipeYOffset - rectWithBorder.getY() + rect.getY());
        Rect2i layoutArea = this.recipeLayout.getRect();
        Rect2i buttonArea = this.recipeLayout.getRecipeTransferButtonArea();
        buttonArea.setX(buttonArea.getX() + layoutArea.getX());
        buttonArea.setY(buttonArea.getY() + layoutArea.getY());
        this.transferButton.updateBounds(buttonArea);
        buttonArea = this.recipeLayout.getRecipeBookmarkButtonArea();
        buttonArea.setX(buttonArea.getX() + layoutArea.getX());
        buttonArea.setY(buttonArea.getY() + layoutArea.getY());
        this.bookmarkButton.updateBounds(buttonArea);
    }

    @Override
    public int totalWidth() {
        int buttonRight;
        Rect2i buttonArea;
        Rect2i area = this.recipeLayout.getRect();
        Rect2i areaWithBorder = this.recipeLayout.getRectWithBorder();
        int leftBorderWidth = area.getX() - areaWithBorder.getX();
        int rightAreaWidth = areaWithBorder.getWidth() - leftBorderWidth;
        if (this.transferButton.isVisible()) {
            buttonArea = this.recipeLayout.getRecipeTransferButtonArea();
            buttonRight = buttonArea.getX() + buttonArea.getWidth();
            rightAreaWidth = Math.max(buttonRight, rightAreaWidth);
        }
        if (this.bookmarkButton.isVisible()) {
            buttonArea = this.recipeLayout.getRecipeBookmarkButtonArea();
            buttonRight = buttonArea.getX() + buttonArea.getWidth();
            rightAreaWidth = Math.max(buttonRight, rightAreaWidth);
        }
        return leftBorderWidth + rightAreaWidth;
    }

    @Override
    public IUserInputHandler createUserInputHandler() {
        return new CombinedInputHandler("RecipeLayoutWithButtons", this.bookmarkButton.createInputHandler(), this.transferButton.createInputHandler(), new RecipeLayoutUserInputHandler<R>(this.recipeLayout));
    }

    @Override
    public void tick(@Nullable AbstractContainerMenu parentContainer, @Nullable Player player) {
        this.recipeLayout.tick();
        this.transferButton.update(parentContainer, player);
        this.bookmarkButton.tick();
    }

    @Override
    public IRecipeLayoutDrawable<R> getRecipeLayout() {
        return this.recipeLayout;
    }

    @Override
    public void drawTooltips(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        this.transferButton.drawTooltips(guiGraphics, mouseX, mouseY);
        this.bookmarkButton.drawTooltips(guiGraphics, mouseX, mouseY);
    }

    @Override
    public int getMissingCountHint() {
        return this.transferButton.getMissingCountHint();
    }

    private record RecipeLayoutUserInputHandler<R>(IRecipeLayoutDrawable<R> recipeLayout) implements IUserInputHandler
    {
        @Override
        public Optional<IUserInputHandler> handleUserInput(Screen screen, IGuiProperties guiProperties, UserInput input, IInternalKeyMappings keyBindings) {
            double mouseY;
            double mouseX = input.getMouseX();
            if (this.recipeLayout.isMouseOver(mouseX, mouseY = input.getMouseY())) {
                InputConstants.Key key = input.getKey();
                boolean simulate = input.isSimulate();
                if (this.recipeLayout.getInputHandler().handleInput(mouseX, mouseY, input)) {
                    return Optional.of(this);
                }
                IInternalKeyMappings keyMappings = Internal.getKeyMappings();
                if (keyMappings.getCopyRecipeId().isActiveAndMatches(key) && this.handleCopyRecipeId(this.recipeLayout, simulate)) {
                    return Optional.of(this);
                }
            }
            return Optional.empty();
        }

        private boolean handleCopyRecipeId(IRecipeLayoutDrawable<R> recipeLayout, boolean simulate) {
            R recipe;
            if (simulate) {
                return true;
            }
            Minecraft minecraft = Minecraft.getInstance();
            LocalPlayer player = minecraft.player;
            IRecipeCategory<R> recipeCategory = recipeLayout.getRecipeCategory();
            Identifier registryId = recipeCategory.getIdentifier(recipe = recipeLayout.getRecipe());
            if (registryId == null) {
                MutableComponent message = Component.translatable((String)"jei.message.copy.recipe.id.failure");
                if (player != null) {
                    player.displayClientMessage((Component)message, false);
                }
                return false;
            }
            String recipeId = registryId.toString();
            minecraft.keyboardHandler.setClipboard(recipeId);
            MutableComponent message = Component.translatable((String)"jei.message.copy.recipe.id.success", (Object[])new Object[]{Component.literal((String)recipeId)});
            if (player != null) {
                player.displayClientMessage((Component)message, false);
            }
            return true;
        }

        @Override
        public Optional<IUserInputHandler> handleMouseScrolled(double mouseX, double mouseY, double scrollDeltaX, double scrollDeltaY) {
            if (this.recipeLayout.isMouseOver(mouseX, mouseY) && this.recipeLayout.getInputHandler().handleMouseScrolled(mouseX, mouseY, scrollDeltaX, scrollDeltaY)) {
                return Optional.of(this);
            }
            return Optional.empty();
        }
    }
}

