/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.library.plugins.vanilla.cooking.fuel;

import java.text.NumberFormat;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.placement.HorizontalAlignment;
import mezz.jei.api.gui.placement.VerticalAlignment;
import mezz.jei.api.gui.widgets.IRecipeExtrasBuilder;
import mezz.jei.api.gui.widgets.ITextWidget;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.category.AbstractRecipeCategory;
import mezz.jei.api.recipe.types.IRecipeType;
import mezz.jei.api.recipe.vanilla.IJeiFuelingRecipe;
import mezz.jei.common.gui.textures.Textures;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.Identifier;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3x2fStack;

public abstract class AbstractFuelCategory
extends AbstractRecipeCategory<IJeiFuelingRecipe> {
    private final int burnDivisor;

    protected AbstractFuelCategory(Textures textures, IRecipeType<IJeiFuelingRecipe> recipeType, Component title, IDrawable icon, int burnDivisor) {
        super(recipeType, title, (IDrawable)new IconWithFlameOverlay(textures, icon), AbstractFuelCategory.getMaxWidth(), 34);
        if (burnDivisor <= 0) {
            throw new IllegalArgumentException("burnDivisor must be greater than 0");
        }
        this.burnDivisor = burnDivisor;
    }

    private static int getMaxWidth() {
        Minecraft minecraft = Minecraft.getInstance();
        Font fontRenderer = minecraft.font;
        Component maxSmeltCountText = AbstractFuelCategory.createSmeltCountText(2000000000);
        int maxStringWidth = fontRenderer.width(maxSmeltCountText.getString());
        int textPadding = 20;
        return 18 + textPadding + maxStringWidth;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, IJeiFuelingRecipe recipe, IFocusGroup focuses) {
        builder.addInputSlot(1, 17).setStandardSlotBackground().addItemStacks(recipe.getInputs());
    }

    public void createRecipeExtras(IRecipeExtrasBuilder builder, IJeiFuelingRecipe recipe, IFocusGroup focuses) {
        int burnTime = recipe.getBurnTime() / this.burnDivisor;
        builder.addAnimatedRecipeFlame(burnTime).setPosition(1, 0);
        Component smeltCountText = AbstractFuelCategory.createSmeltCountText(burnTime);
        ((ITextWidget)builder.addText((FormattedText)smeltCountText, this.getWidth() - 20, this.getHeight()).setPosition(20, 0)).setTextAlignment(HorizontalAlignment.CENTER).setTextAlignment(VerticalAlignment.CENTER).setColor(-8355712);
    }

    public static Component createSmeltCountText(int burnTime) {
        if (burnTime == 200) {
            return Component.translatable((String)"gui.jei.category.fuel.smeltCount.single");
        }
        NumberFormat numberInstance = NumberFormat.getNumberInstance();
        numberInstance.setMaximumFractionDigits(2);
        String smeltCount = numberInstance.format((float)burnTime / 200.0f);
        return Component.translatable((String)"gui.jei.category.fuel.smeltCount", (Object[])new Object[]{smeltCount});
    }

    @Nullable
    public Identifier getIdentifier(IJeiFuelingRecipe recipe) {
        return null;
    }

    private static class IconWithFlameOverlay
    implements IDrawable {
        private final IDrawable icon;
        private final IDrawable flameIcon;

        public IconWithFlameOverlay(Textures textures, IDrawable icon) {
            this.icon = icon;
            this.flameIcon = textures.getFlameIcon();
        }

        public int getWidth() {
            return 16;
        }

        public int getHeight() {
            return 16;
        }

        public void draw(GuiGraphics guiGraphics, int xOffset, int yOffset) {
            this.icon.draw(guiGraphics, xOffset, yOffset);
            Matrix3x2fStack poseStack = guiGraphics.pose();
            poseStack.pushMatrix();
            poseStack.translate((float)(8 + xOffset), (float)(8 + yOffset));
            poseStack.scale(0.5f, 0.5f);
            this.flameIcon.draw(guiGraphics);
            poseStack.popMatrix();
        }
    }
}

