/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.library.plugins.vanilla;

import com.mojang.serialization.Codec;
import java.util.Comparator;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Stream;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.handlers.IGlobalGuiHandler;
import mezz.jei.api.gui.handlers.IGuiContainerHandler;
import mezz.jei.api.helpers.IColorHelper;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.IIngredientTypeWithSubtypes;
import mezz.jei.api.ingredients.subtypes.ISubtypeInterpreter;
import mezz.jei.api.ingredients.subtypes.ISubtypeManager;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.category.extensions.vanilla.crafting.ICraftingCategoryExtension;
import mezz.jei.api.recipe.category.extensions.vanilla.crafting.IExtendableCraftingRecipeCategory;
import mezz.jei.api.recipe.category.extensions.vanilla.smithing.IExtendableSmithingRecipeCategory;
import mezz.jei.api.recipe.category.extensions.vanilla.smithing.ISmithingCategoryExtension;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandlerHelper;
import mezz.jei.api.recipe.types.IRecipeType;
import mezz.jei.api.recipe.vanilla.IJeiBrewingRecipe;
import mezz.jei.api.recipe.vanilla.IVanillaRecipeFactory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IModInfoRegistration;
import mezz.jei.api.registration.IModIngredientRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import mezz.jei.api.registration.IVanillaCategoryExtensionRegistration;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.common.Internal;
import mezz.jei.common.gui.textures.Textures;
import mezz.jei.common.platform.IPlatformFluidHelperInternal;
import mezz.jei.common.platform.IPlatformRecipeHelper;
import mezz.jei.common.platform.Services;
import mezz.jei.common.util.ErrorUtil;
import mezz.jei.common.util.RegistryUtil;
import mezz.jei.common.util.StackHelper;
import mezz.jei.library.plugins.vanilla.anvil.AnvilRecipeCategory;
import mezz.jei.library.plugins.vanilla.anvil.AnvilRecipeMaker;
import mezz.jei.library.plugins.vanilla.anvil.SmithingRecipeCategory;
import mezz.jei.library.plugins.vanilla.anvil.SmithingTransformCategoryExtension;
import mezz.jei.library.plugins.vanilla.anvil.SmithingTrimCategoryExtension;
import mezz.jei.library.plugins.vanilla.brewing.BrewingRecipeCategory;
import mezz.jei.library.plugins.vanilla.compostable.CompostableRecipeCategory;
import mezz.jei.library.plugins.vanilla.compostable.CompostingRecipeMaker;
import mezz.jei.library.plugins.vanilla.cooking.BlastingCategory;
import mezz.jei.library.plugins.vanilla.cooking.CampfireCookingCategory;
import mezz.jei.library.plugins.vanilla.cooking.FurnaceSmeltingCategory;
import mezz.jei.library.plugins.vanilla.cooking.SmokingCategory;
import mezz.jei.library.plugins.vanilla.cooking.fuel.BlastingFuelCategory;
import mezz.jei.library.plugins.vanilla.cooking.fuel.FuelRecipeMaker;
import mezz.jei.library.plugins.vanilla.cooking.fuel.SmeltingFuelCategory;
import mezz.jei.library.plugins.vanilla.cooking.fuel.SmokingFuelCategory;
import mezz.jei.library.plugins.vanilla.crafting.CraftingCategoryExtension;
import mezz.jei.library.plugins.vanilla.crafting.CraftingRecipeCategory;
import mezz.jei.library.plugins.vanilla.crafting.VanillaRecipes;
import mezz.jei.library.plugins.vanilla.crafting.replacers.ShieldDecorationRecipeMaker;
import mezz.jei.library.plugins.vanilla.crafting.replacers.TippedArrowRecipeMaker;
import mezz.jei.library.plugins.vanilla.grindstone.GrindstoneRecipeCategory;
import mezz.jei.library.plugins.vanilla.grindstone.GrindstoneRecipeMaker;
import mezz.jei.library.plugins.vanilla.gui.InventoryEffectRendererGuiHandler;
import mezz.jei.library.plugins.vanilla.gui.RecipeBookGuiHandler;
import mezz.jei.library.plugins.vanilla.gui.ToastGuiHandler;
import mezz.jei.library.plugins.vanilla.ingredients.ItemStackHelper;
import mezz.jei.library.plugins.vanilla.ingredients.ItemStackListFactory;
import mezz.jei.library.plugins.vanilla.ingredients.fluid.FluidIngredientHelper;
import mezz.jei.library.plugins.vanilla.ingredients.fluid.FluidStackListFactory;
import mezz.jei.library.plugins.vanilla.ingredients.subtypes.EnchantedBookSubtypeInterpreter;
import mezz.jei.library.plugins.vanilla.ingredients.subtypes.LightSubtypeInterpreter;
import mezz.jei.library.plugins.vanilla.ingredients.subtypes.PotionSubtypeInterpreter;
import mezz.jei.library.plugins.vanilla.stonecutting.StoneCuttingRecipeCategory;
import mezz.jei.library.render.FluidTankRenderer;
import mezz.jei.library.render.ItemStackRenderer;
import mezz.jei.library.transfer.PlayerRecipeTransferHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.AbstractFurnaceScreen;
import net.minecraft.client.gui.screens.inventory.AnvilScreen;
import net.minecraft.client.gui.screens.inventory.BlastFurnaceScreen;
import net.minecraft.client.gui.screens.inventory.BrewingStandScreen;
import net.minecraft.client.gui.screens.inventory.CrafterScreen;
import net.minecraft.client.gui.screens.inventory.CraftingScreen;
import net.minecraft.client.gui.screens.inventory.FurnaceScreen;
import net.minecraft.client.gui.screens.inventory.GrindstoneScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.gui.screens.inventory.SmithingScreen;
import net.minecraft.client.gui.screens.inventory.SmokerScreen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.inventory.AnvilMenu;
import net.minecraft.world.inventory.BlastFurnaceMenu;
import net.minecraft.world.inventory.BrewingStandMenu;
import net.minecraft.world.inventory.CrafterMenu;
import net.minecraft.world.inventory.CraftingMenu;
import net.minecraft.world.inventory.FurnaceMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SmithingMenu;
import net.minecraft.world.inventory.SmokerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionBrewing;
import net.minecraft.world.item.crafting.BlastingRecipe;
import net.minecraft.world.item.crafting.CampfireCookingRecipe;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeMap;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShieldDecorationRecipe;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.item.crafting.SmithingRecipe;
import net.minecraft.world.item.crafting.SmithingTransformRecipe;
import net.minecraft.world.item.crafting.SmithingTrimRecipe;
import net.minecraft.world.item.crafting.SmokingRecipe;
import net.minecraft.world.item.crafting.StonecutterRecipe;
import net.minecraft.world.item.crafting.TippedArrowRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.Fluid;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

@JeiPlugin
public class VanillaPlugin
implements IModPlugin {
    private static final Logger LOGGER = LogManager.getLogger();
    @Nullable
    private CraftingRecipeCategory craftingCategory;
    @Nullable
    private IRecipeCategory<RecipeHolder<StonecutterRecipe>> stonecuttingCategory;
    @Nullable
    private IRecipeCategory<RecipeHolder<SmeltingRecipe>> furnaceCategory;
    @Nullable
    private IRecipeCategory<RecipeHolder<SmokingRecipe>> smokingCategory;
    @Nullable
    private IRecipeCategory<RecipeHolder<BlastingRecipe>> blastingCategory;
    @Nullable
    private IRecipeCategory<RecipeHolder<CampfireCookingRecipe>> campfireCategory;
    @Nullable
    private SmithingRecipeCategory smithingCategory;

    public Identifier getPluginUid() {
        return Identifier.fromNamespaceAndPath((String)"jei", (String)"minecraft");
    }

    public void registerItemSubtypes(ISubtypeRegistration registration) {
        registration.registerSubtypeInterpreter(Items.TIPPED_ARROW, (ISubtypeInterpreter)PotionSubtypeInterpreter.INSTANCE);
        registration.registerSubtypeInterpreter(Items.POTION, (ISubtypeInterpreter)PotionSubtypeInterpreter.INSTANCE);
        registration.registerSubtypeInterpreter(Items.SPLASH_POTION, (ISubtypeInterpreter)PotionSubtypeInterpreter.INSTANCE);
        registration.registerSubtypeInterpreter(Items.LINGERING_POTION, (ISubtypeInterpreter)PotionSubtypeInterpreter.INSTANCE);
        registration.registerSubtypeInterpreter(Items.ENCHANTED_BOOK, (ISubtypeInterpreter)EnchantedBookSubtypeInterpreter.INSTANCE);
        registration.registerSubtypeInterpreter(Items.LIGHT, (ISubtypeInterpreter)LightSubtypeInterpreter.INSTANCE);
        registration.registerFromDataComponentTypes(Items.PAINTING, new DataComponentType[]{DataComponents.PAINTING_VARIANT});
        registration.registerFromDataComponentTypes(Items.GOAT_HORN, new DataComponentType[]{DataComponents.INSTRUMENT});
        registration.registerFromDataComponentTypes(Items.FIREWORK_ROCKET, new DataComponentType[]{DataComponents.FIREWORKS});
        registration.registerFromDataComponentTypes(Items.FIREWORK_STAR, new DataComponentType[]{DataComponents.FIREWORK_EXPLOSION});
        registration.registerFromDataComponentTypes(Items.SUSPICIOUS_STEW, new DataComponentType[]{DataComponents.SUSPICIOUS_STEW_EFFECTS});
        registration.registerFromDataComponentTypes(Items.OMINOUS_BOTTLE, new DataComponentType[]{DataComponents.OMINOUS_BOTTLE_AMPLIFIER});
        registration.registerFromDataComponentTypes(Items.SHIELD, new DataComponentType[]{DataComponents.BASE_COLOR, DataComponents.BANNER_PATTERNS});
        registration.registerFromDataComponentTypes(Items.DECORATED_POT, new DataComponentType[]{DataComponents.POT_DECORATIONS});
    }

    public void registerIngredients(IModIngredientRegistration registration) {
        ISubtypeManager subtypeManager = registration.getSubtypeManager();
        IColorHelper colorHelper = registration.getColorHelper();
        StackHelper stackHelper = new StackHelper(subtypeManager);
        ItemStackHelper itemStackHelper = new ItemStackHelper(stackHelper, colorHelper);
        List<ItemStack> itemStacks = ItemStackListFactory.create(stackHelper, itemStackHelper);
        ItemStackRenderer itemStackRenderer = new ItemStackRenderer();
        registration.register((IIngredientType)VanillaTypes.ITEM_STACK, itemStacks, (IIngredientHelper)itemStackHelper, (IIngredientRenderer)itemStackRenderer, ItemStack.STRICT_SINGLE_ITEM_CODEC);
        IPlatformFluidHelperInternal platformFluidHelper = Services.PLATFORM.getFluidHelper();
        this.registerFluidIngredients(registration, platformFluidHelper);
    }

    public void registerModInfo(IModInfoRegistration registration) {
        registration.addModAliases("minecraft", new String[]{"mc"});
    }

    private <T> void registerFluidIngredients(IModIngredientRegistration registration, IPlatformFluidHelperInternal<T> platformFluidHelper) {
        ISubtypeManager subtypeManager = registration.getSubtypeManager();
        IColorHelper colorHelper = registration.getColorHelper();
        Registry registry = RegistryUtil.getRegistry((ResourceKey)Registries.FLUID);
        List<T> fluidIngredients = FluidStackListFactory.create((Registry<Fluid>)registry, platformFluidHelper);
        FluidIngredientHelper<T> fluidIngredientHelper = new FluidIngredientHelper<T>(subtypeManager, colorHelper, platformFluidHelper);
        FluidTankRenderer<T> fluidTankRenderer = new FluidTankRenderer<T>(platformFluidHelper);
        IIngredientTypeWithSubtypes fluidIngredientType = platformFluidHelper.getFluidIngredientType();
        Codec codec = platformFluidHelper.getCodec();
        registration.register((IIngredientType)fluidIngredientType, fluidIngredients, fluidIngredientHelper, fluidTankRenderer, codec);
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        Textures textures = Internal.getTextures();
        IJeiHelpers jeiHelpers = registration.getJeiHelpers();
        IGuiHelper guiHelper = jeiHelpers.getGuiHelper();
        IRecipeCategory[] iRecipeCategoryArray = new IRecipeCategory[14];
        this.craftingCategory = new CraftingRecipeCategory(guiHelper);
        iRecipeCategoryArray[0] = this.craftingCategory;
        this.stonecuttingCategory = new StoneCuttingRecipeCategory(guiHelper);
        iRecipeCategoryArray[1] = this.stonecuttingCategory;
        this.furnaceCategory = new FurnaceSmeltingCategory(guiHelper);
        iRecipeCategoryArray[2] = this.furnaceCategory;
        this.smokingCategory = new SmokingCategory(guiHelper);
        iRecipeCategoryArray[3] = this.smokingCategory;
        this.blastingCategory = new BlastingCategory(guiHelper);
        iRecipeCategoryArray[4] = this.blastingCategory;
        this.campfireCategory = new CampfireCookingCategory(guiHelper);
        iRecipeCategoryArray[5] = this.campfireCategory;
        this.smithingCategory = new SmithingRecipeCategory(guiHelper);
        iRecipeCategoryArray[6] = this.smithingCategory;
        iRecipeCategoryArray[7] = new CompostableRecipeCategory(guiHelper);
        iRecipeCategoryArray[8] = new SmeltingFuelCategory(guiHelper, textures);
        iRecipeCategoryArray[9] = new SmokingFuelCategory(guiHelper, textures);
        iRecipeCategoryArray[10] = new BlastingFuelCategory(guiHelper, textures);
        iRecipeCategoryArray[11] = new BrewingRecipeCategory(guiHelper);
        iRecipeCategoryArray[12] = new AnvilRecipeCategory(guiHelper);
        iRecipeCategoryArray[13] = new GrindstoneRecipeCategory(guiHelper);
        registration.addRecipeCategories(iRecipeCategoryArray);
    }

    public void registerVanillaCategoryExtensions(IVanillaCategoryExtensionRegistration registration) {
        IExtendableCraftingRecipeCategory craftingCategory = registration.getCraftingCategory();
        craftingCategory.addExtension(CraftingRecipe.class, (ICraftingCategoryExtension)new CraftingCategoryExtension());
        IExtendableSmithingRecipeCategory smithingCategory = registration.getSmithingCategory();
        IPlatformRecipeHelper recipeHelper = Services.PLATFORM.getRecipeHelper();
        smithingCategory.addExtension(SmithingTransformRecipe.class, (ISmithingCategoryExtension)new SmithingTransformCategoryExtension(recipeHelper));
        smithingCategory.addExtension(SmithingTrimRecipe.class, (ISmithingCategoryExtension)new SmithingTrimCategoryExtension(recipeHelper));
    }

    public void registerRecipes(IRecipeRegistration registration) {
        RecipeMap clientSyncedRecipes = Internal.getClientSyncedRecipes();
        if (clientSyncedRecipes.values().isEmpty()) {
            return;
        }
        ErrorUtil.checkNotNull((Object)((Object)this.craftingCategory), (String)"craftingCategory");
        ErrorUtil.checkNotNull(this.stonecuttingCategory, (String)"stonecuttingCategory");
        ErrorUtil.checkNotNull(this.furnaceCategory, (String)"furnaceCategory");
        ErrorUtil.checkNotNull(this.smokingCategory, (String)"smokingCategory");
        ErrorUtil.checkNotNull(this.blastingCategory, (String)"blastingCategory");
        ErrorUtil.checkNotNull(this.campfireCategory, (String)"campfireCategory");
        ErrorUtil.checkNotNull((Object)((Object)this.smithingCategory), (String)"smithingCategory");
        IIngredientManager ingredientManager = registration.getIngredientManager();
        IVanillaRecipeFactory vanillaRecipeFactory = registration.getVanillaRecipeFactory();
        IJeiHelpers jeiHelpers = registration.getJeiHelpers();
        VanillaRecipes vanillaRecipes = new VanillaRecipes(clientSyncedRecipes);
        VanillaRecipes.CraftingRecipes craftingRecipes = vanillaRecipes.getCraftingRecipes((IRecipeCategory<RecipeHolder<CraftingRecipe>>)this.craftingCategory);
        List<RecipeHolder<CraftingRecipe>> handledCraftingRecipes = craftingRecipes.getHandled();
        List<RecipeHolder<CraftingRecipe>> unhandledCraftingRecipes = craftingRecipes.getUnhandled();
        List<RecipeHolder<CraftingRecipe>> specialCraftingRecipes = VanillaPlugin.replaceSpecialCraftingRecipes(unhandledCraftingRecipes, jeiHelpers);
        registration.addRecipes((IRecipeType)RecipeTypes.CRAFTING, handledCraftingRecipes);
        registration.addRecipes((IRecipeType)RecipeTypes.CRAFTING, specialCraftingRecipes);
        registration.addRecipes((IRecipeType)RecipeTypes.STONECUTTING, vanillaRecipes.getStonecuttingRecipes(this.stonecuttingCategory));
        registration.addRecipes((IRecipeType)RecipeTypes.SMELTING, vanillaRecipes.getFurnaceRecipes(this.furnaceCategory));
        registration.addRecipes((IRecipeType)RecipeTypes.SMOKING, vanillaRecipes.getSmokingRecipes(this.smokingCategory));
        registration.addRecipes((IRecipeType)RecipeTypes.BLASTING, vanillaRecipes.getBlastingRecipes(this.blastingCategory));
        registration.addRecipes((IRecipeType)RecipeTypes.CAMPFIRE_COOKING, vanillaRecipes.getCampfireCookingRecipes(this.campfireCategory));
        registration.addRecipes(RecipeTypes.SMELTING_FUEL, FuelRecipeMaker.getFuelRecipes(ingredientManager, RecipeType.SMELTING));
        registration.addRecipes(RecipeTypes.SMOKING_FUEL, FuelRecipeMaker.getFuelRecipes(ingredientManager, RecipeType.SMOKING));
        registration.addRecipes(RecipeTypes.BLASTING_FUEL, FuelRecipeMaker.getFuelRecipes(ingredientManager, RecipeType.BLASTING));
        registration.addRecipes(RecipeTypes.ANVIL, AnvilRecipeMaker.getAnvilRecipes(vanillaRecipeFactory, ingredientManager));
        registration.addRecipes((IRecipeType)RecipeTypes.SMITHING, vanillaRecipes.getSmithingRecipes((IRecipeCategory<RecipeHolder<SmithingRecipe>>)this.smithingCategory));
        registration.addRecipes(RecipeTypes.COMPOSTING, CompostingRecipeMaker.getRecipes(ingredientManager));
        Minecraft minecraft = Minecraft.getInstance();
        ClientLevel level = minecraft.level;
        ErrorUtil.checkNotNull((Object)level, (String)"minecraft.level");
        PotionBrewing potionBrewing = level.potionBrewing();
        IPlatformRecipeHelper recipeHelper = Services.PLATFORM.getRecipeHelper();
        List brewingRecipes = recipeHelper.getBrewingRecipes(ingredientManager, vanillaRecipeFactory, potionBrewing);
        brewingRecipes.sort(Comparator.comparingInt(IJeiBrewingRecipe::getBrewingSteps));
        registration.addRecipes(RecipeTypes.BREWING, brewingRecipes);
        registration.addRecipes(RecipeTypes.GRINDSTONE, GrindstoneRecipeMaker.getGrindstoneRecipes(ingredientManager, recipeHelper));
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addRecipeClickArea(CraftingScreen.class, 88, 32, 28, 23, new IRecipeType[]{RecipeTypes.CRAFTING});
        registration.addRecipeClickArea(CrafterScreen.class, 88, 32, 28, 23, new IRecipeType[]{RecipeTypes.CRAFTING});
        registration.addRecipeClickArea(InventoryScreen.class, 137, 29, 10, 13, new IRecipeType[]{RecipeTypes.CRAFTING});
        registration.addRecipeClickArea(BrewingStandScreen.class, 97, 16, 14, 30, new IRecipeType[]{RecipeTypes.BREWING});
        registration.addRecipeClickArea(FurnaceScreen.class, 78, 32, 28, 23, new IRecipeType[]{RecipeTypes.SMELTING, RecipeTypes.SMELTING_FUEL});
        registration.addRecipeClickArea(SmokerScreen.class, 78, 32, 28, 23, new IRecipeType[]{RecipeTypes.SMOKING, RecipeTypes.SMOKING_FUEL});
        registration.addRecipeClickArea(BlastFurnaceScreen.class, 78, 32, 28, 23, new IRecipeType[]{RecipeTypes.BLASTING, RecipeTypes.BLASTING_FUEL});
        registration.addRecipeClickArea(AnvilScreen.class, 102, 48, 22, 15, new IRecipeType[]{RecipeTypes.ANVIL});
        registration.addRecipeClickArea(GrindstoneScreen.class, 92, 31, 28, 21, new IRecipeType[]{RecipeTypes.GRINDSTONE});
        registration.addRecipeClickArea(SmithingScreen.class, 68, 49, 22, 15, new IRecipeType[]{RecipeTypes.SMITHING});
        registration.addGenericGuiContainerHandler(AbstractContainerScreen.class, (IGuiContainerHandler)new InventoryEffectRendererGuiHandler());
        registration.addGuiContainerHandler(CraftingScreen.class, new RecipeBookGuiHandler());
        registration.addGuiContainerHandler(InventoryScreen.class, new RecipeBookGuiHandler());
        registration.addGenericGuiContainerHandler(AbstractFurnaceScreen.class, new RecipeBookGuiHandler());
        registration.addGlobalGuiHandler((IGlobalGuiHandler)new ToastGuiHandler());
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registration) {
        registration.addRecipeTransferHandler(CraftingMenu.class, MenuType.CRAFTING, (IRecipeType)RecipeTypes.CRAFTING, 1, 9, 10, 36);
        registration.addRecipeTransferHandler(CrafterMenu.class, MenuType.CRAFTER_3x3, (IRecipeType)RecipeTypes.CRAFTING, 0, 9, 9, 36);
        registration.addRecipeTransferHandler(FurnaceMenu.class, MenuType.FURNACE, (IRecipeType)RecipeTypes.SMELTING, 0, 1, 3, 36);
        registration.addRecipeTransferHandler(FurnaceMenu.class, MenuType.FURNACE, RecipeTypes.SMELTING_FUEL, 1, 1, 3, 36);
        registration.addRecipeTransferHandler(SmokerMenu.class, MenuType.SMOKER, (IRecipeType)RecipeTypes.SMOKING, 0, 1, 3, 36);
        registration.addRecipeTransferHandler(SmokerMenu.class, MenuType.SMOKER, RecipeTypes.SMOKING_FUEL, 1, 1, 3, 36);
        registration.addRecipeTransferHandler(BlastFurnaceMenu.class, MenuType.BLAST_FURNACE, (IRecipeType)RecipeTypes.BLASTING, 0, 1, 3, 36);
        registration.addRecipeTransferHandler(BlastFurnaceMenu.class, MenuType.BLAST_FURNACE, RecipeTypes.BLASTING_FUEL, 1, 1, 3, 36);
        registration.addRecipeTransferHandler(BrewingStandMenu.class, MenuType.BREWING_STAND, RecipeTypes.BREWING, 0, 4, 5, 36);
        registration.addRecipeTransferHandler(AnvilMenu.class, MenuType.ANVIL, RecipeTypes.ANVIL, 0, 2, 3, 36);
        registration.addRecipeTransferHandler(SmithingMenu.class, MenuType.SMITHING, (IRecipeType)RecipeTypes.SMITHING, 0, 3, 3, 36);
        IRecipeTransferHandlerHelper transferHelper = registration.getTransferHelper();
        PlayerRecipeTransferHandler recipeTransferHandler = new PlayerRecipeTransferHandler(transferHelper);
        registration.addRecipeTransferHandler((IRecipeTransferHandler)recipeTransferHandler, (IRecipeType)RecipeTypes.CRAFTING);
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addCraftingStation((IRecipeType)RecipeTypes.CRAFTING, new ItemLike[]{Blocks.CRAFTING_TABLE, Blocks.CRAFTER});
        registration.addCraftingStation((IRecipeType)RecipeTypes.CAMPFIRE_COOKING, new ItemLike[]{Blocks.CAMPFIRE, Blocks.SOUL_CAMPFIRE});
        registration.addCraftingStation((IRecipeType)RecipeTypes.STONECUTTING, new ItemLike[]{Blocks.STONECUTTER});
        registration.addCraftingStation((IRecipeType)RecipeTypes.SMELTING, new ItemLike[]{Blocks.FURNACE});
        registration.addCraftingStation((IRecipeType)RecipeTypes.SMOKING, new ItemLike[]{Blocks.SMOKER});
        registration.addCraftingStation((IRecipeType)RecipeTypes.BLASTING, new ItemLike[]{Blocks.BLAST_FURNACE});
        registration.addCraftingStation(RecipeTypes.SMELTING_FUEL, new ItemLike[]{Blocks.FURNACE});
        registration.addCraftingStation(RecipeTypes.SMOKING_FUEL, new ItemLike[]{Blocks.SMOKER});
        registration.addCraftingStation(RecipeTypes.BLASTING_FUEL, new ItemLike[]{Blocks.BLAST_FURNACE});
        registration.addCraftingStation(RecipeTypes.BREWING, new ItemLike[]{Blocks.BREWING_STAND});
        registration.addCraftingStation(RecipeTypes.ANVIL, new ItemLike[]{Blocks.ANVIL});
        registration.addCraftingStation(RecipeTypes.GRINDSTONE, new ItemLike[]{Blocks.GRINDSTONE});
        registration.addCraftingStation((IRecipeType)RecipeTypes.SMITHING, new ItemLike[]{Blocks.SMITHING_TABLE});
        registration.addCraftingStation(RecipeTypes.COMPOSTING, new ItemLike[]{Blocks.COMPOSTER});
    }

    public Optional<CraftingRecipeCategory> getCraftingCategory() {
        return Optional.ofNullable(this.craftingCategory);
    }

    public Optional<SmithingRecipeCategory> getSmithingCategory() {
        return Optional.ofNullable(this.smithingCategory);
    }

    private static List<RecipeHolder<CraftingRecipe>> replaceSpecialCraftingRecipes(List<RecipeHolder<CraftingRecipe>> unhandledCraftingRecipes, IJeiHelpers jeiHelpers) {
        IdentityHashMap<Class, Supplier<List>> replacers = new IdentityHashMap<Class, Supplier<List>>();
        replacers.put(TippedArrowRecipe.class, () -> TippedArrowRecipeMaker.createRecipes(jeiHelpers));
        replacers.put(ShieldDecorationRecipe.class, ShieldDecorationRecipeMaker::createRecipes);
        return unhandledCraftingRecipes.stream().map(RecipeHolder::value).map(CraftingRecipe::getClass).filter(replacers::containsKey).distinct().limit(replacers.size()).flatMap(recipeClass -> {
            Supplier supplier = (Supplier)replacers.get(recipeClass);
            try {
                return ((List)supplier.get()).stream();
            }
            catch (RuntimeException e) {
                LOGGER.error("Failed to create JEI recipes for {}", recipeClass, (Object)e);
                return Stream.of(new RecipeHolder[0]);
            }
        }).toList();
    }
}

