/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.library.ingredients.subtypes;

import mezz.jei.api.ingredients.IIngredientTypeWithSubtypes;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.ingredients.subtypes.ISubtypeInterpreter;
import mezz.jei.api.ingredients.subtypes.ISubtypeManager;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.common.util.ErrorUtil;
import mezz.jei.library.ingredients.subtypes.SubtypeInterpreters;
import org.jetbrains.annotations.Nullable;

public class SubtypeManager
implements ISubtypeManager {
    private final SubtypeInterpreters interpreters;

    public SubtypeManager(SubtypeInterpreters interpreters) {
        this.interpreters = interpreters;
    }

    @Nullable
    public <T> Object getSubtypeData(IIngredientTypeWithSubtypes<?, T> ingredientType, T ingredient, UidContext context) {
        ErrorUtil.checkNotNull(ingredientType, (String)"ingredientType");
        ErrorUtil.checkNotNull(ingredient, (String)"ingredient");
        ErrorUtil.checkNotNull((Object)context, (String)"type");
        ISubtypeInterpreter<T> interpreter = this.interpreters.get(ingredientType, ingredient);
        if (interpreter == null) {
            return null;
        }
        return interpreter.getSubtypeData(ingredient, context);
    }

    @Nullable
    public <B, T> Object getSubtypeData(IIngredientTypeWithSubtypes<B, T> ingredientType, ITypedIngredient<T> typedIngredient, UidContext context) {
        ErrorUtil.checkNotNull(ingredientType, (String)"ingredientType");
        ErrorUtil.checkNotNull(typedIngredient, (String)"typedIngredient");
        ErrorUtil.checkNotNull((Object)context, (String)"type");
        Object ingredientBase = typedIngredient.getBaseIngredient(ingredientType);
        ISubtypeInterpreter<T> interpreter = this.interpreters.getFromBase(ingredientType, ingredientBase);
        if (interpreter == null) {
            return null;
        }
        Object ingredient = typedIngredient.getIngredient();
        return interpreter.getSubtypeData(ingredient, context);
    }

    public <T, B> boolean hasSubtypes(IIngredientTypeWithSubtypes<B, T> ingredientType, T ingredient) {
        ErrorUtil.checkNotNull(ingredientType, (String)"ingredientType");
        ErrorUtil.checkNotNull(ingredient, (String)"ingredient");
        return this.interpreters.contains(ingredientType, ingredient);
    }
}

