package mezz.jei.common.gui.elements;

import mezz.jei.api.gui.drawable.IScalableDrawable;
import mezz.jei.common.gui.textures.JeiAtlasManager;
import mezz.jei.common.platform.IPlatformRenderHelper;
import mezz.jei.common.platform.Services;
import mezz.jei.common.util.ImmutableRect2i;
import net.minecraft.class_1058;
import net.minecraft.class_10799;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_8689;
import net.minecraft.class_8690;

public class ScalableDrawable implements IScalableDrawable {
	private final JeiAtlasManager atlasManager;
	private final class_2960 spriteId;

	public ScalableDrawable(JeiAtlasManager atlasManager, class_2960 spriteId) {
		this.atlasManager = atlasManager;
		this.spriteId = spriteId;
	}

	public void draw(class_332 guiGraphics, ImmutableRect2i area) {
		draw(guiGraphics, area.getX(), area.getY(), area.getWidth(), area.getHeight());
	}

	@Override
	public void draw(class_332 guiGraphics, int xOffset, int yOffset, int width, int height) {
		class_1058 sprite = atlasManager.getAtlas()
			.method_4608(spriteId);
		class_8690 scaling = sprite.method_45851()
			.method_73021(class_8689.field_45647)
			.orElse(class_8689.field_45645)
			.comp_1636();

		switch (scaling) {
			case class_8690.class_8694 tileScaling -> {
				IPlatformRenderHelper renderHelper = Services.PLATFORM.getRenderHelper();
				renderHelper.blitTiledSprite(
					guiGraphics,
					class_10799.field_56883,
					sprite,
					tileScaling,
					xOffset,
					yOffset,
					width,
					height,
					-1
				);
			}
			case class_8690.class_8691 nineSliceScaling -> {
				IPlatformRenderHelper renderHelper = Services.PLATFORM.getRenderHelper();
				renderHelper.blitNineSlicedSprite(
					guiGraphics,
					class_10799.field_56883,
					sprite,
					nineSliceScaling,
					xOffset,
					yOffset,
					width,
					height
				);
			}
			default -> {
				guiGraphics.method_52709(
					class_10799.field_56883,
					sprite,
					xOffset,
					yOffset,
					width,
					height
				);
			}
		}
	}
}
