package mezz.jei.library.plugins.jei.tags;

import mezz.jei.api.constants.Tags;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.recipe.types.IRecipeType;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.common.platform.IPlatformRenderHelper;
import mezz.jei.common.platform.Services;
import mezz.jei.common.util.RegistryUtil;
import mezz.jei.library.ingredients.TypedIngredient;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;

public record TagInfoRecipeMaker<B, I>(
	IIngredientType<I> ingredientType,
	IRecipeType<ITagInfoRecipe> recipeType,
	Function<B, I> baseToIngredient,
	class_5321<? extends class_2378<B>> registryKey
) {
	private static final Logger LOGGER = LogManager.getLogger();

	public void addRecipes(IRecipeRegistration registration) {
		IIngredientManager ingredientManager = registration.getIngredientManager();
		List<ITagInfoRecipe> recipes = createTagInfoRecipes(ingredientType, registryKey, baseToIngredient, ingredientManager);
		registration.addRecipes(recipeType, recipes);
	}

	private static <B, I> List<ITagInfoRecipe> createTagInfoRecipes(IIngredientType<I> ingredientType, class_5321<? extends class_2378<B>> registryKey, Function<B, I> baseToIngredient, IIngredientManager ingredientManager) {
		class_2378<B> registry = RegistryUtil.getRegistry(registryKey);
		return registry
			.method_40272()
			.map(class_6885.class_6888::method_40251)
			.<ITagInfoRecipe>mapMulti((tagKey, acceptor) -> {
				if (tagKey.comp_327().method_12832().equals(Tags.HIDDEN_FROM_RECIPE_VIEWERS.method_12832())) {
					return;
				}
				List<ITypedIngredient<I>> ingredients = getIngredients(registry, tagKey, ingredientType, baseToIngredient, ingredientManager);
				if (!ingredients.isEmpty()) {
					acceptor.accept(new TagInfoRecipe<>(tagKey, ingredients));
				} else {
					IPlatformRenderHelper renderHelper = Services.PLATFORM.getRenderHelper();
					class_2561 tagName = renderHelper.getName(tagKey);
					LOGGER.debug("No valid ingredients found for {} tag: {} ({})", registryKey.method_29177(), tagName.getString(), tagKey.comp_327());
				}
			})
			.toList();
	}

	private static <B, I> List<ITypedIngredient<I>> getIngredients(class_2378<B> registry, class_6862<B> tagKey, IIngredientType<I> ingredientType, Function<B, I> baseToIngredient, IIngredientManager ingredientManager) {
		List<ITypedIngredient<I>> ingredients = new ArrayList<>();
		for (class_6880<B> i : registry.method_40286(tagKey)) {
			B value = i.comp_349();
			I ingredient = baseToIngredient.apply(value);
			ITypedIngredient<I> typedIngredient = TypedIngredient.createAndFilterInvalid(ingredientManager, ingredientType, ingredient, false);
			if (typedIngredient != null) {
				ingredients.add(typedIngredient);
			}
		}

		return ingredients;
	}
}
