package mezz.jei.fabric;

import mezz.jei.api.constants.ModIds;
import mezz.jei.common.config.IServerConfig;
import mezz.jei.common.network.IConnectionToClient;
import mezz.jei.fabric.config.ServerConfig;
import mezz.jei.fabric.network.ConnectionToClient;
import mezz.jei.fabric.network.ServerNetworkHandler;
import mezz.jei.library.plugins.vanilla.crafting.JeiShapedRecipe;
import mezz.jei.library.recipes.RecipeSerializers;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.recipe.v1.sync.RecipeSynchronization;
import net.minecraft.class_1865;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_7923;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class JustEnoughItems implements ModInitializer {
	private static final Logger LOGGER = LogManager.getLogger();

	@Override
	public void onInitialize() {
		IServerConfig serverConfig = ServerConfig.getInstance();
		IConnectionToClient connection = new ConnectionToClient();
		ServerNetworkHandler.registerServerPacketHandlers(connection, serverConfig);

		class_2960 id = class_2960.method_60655(ModIds.JEI_ID, "jei_shaped");
		var recipeSerializer = new JeiShapedRecipe.Serializer();
		var registered = class_2378.method_10230(class_7923.field_41189, id, recipeSerializer);
		RecipeSerializers.register(() -> registered);

		// Run through vanilla recipe serializers and sync them
		for (var entry : class_7923.field_41189.method_29722()) {
			class_5321<class_1865<?>> resourceKey = entry.getKey();
			if (resourceKey.method_29177().method_12836().equals(ModIds.MINECRAFT_ID)) {
				class_1865<?> serializer = entry.getValue();
				try {
					RecipeSynchronization.synchronizeRecipeSerializer(serializer);
				} catch (RuntimeException e) {
					LOGGER.warn("Failed to synchronize recipe serializer {}", resourceKey, e);
				}
			}
		}
	}
}
