package mezz.jei.library.plugins.vanilla.grindstone;

import mezz.jei.api.recipe.vanilla.IJeiGrindstoneRecipe;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.common.platform.IPlatformRecipeHelper;
import mezz.jei.common.util.RegistryUtil;
import mezz.jei.library.util.ResourceLocationUtil;
import net.minecraft.class_10630;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3803;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import net.minecraft.class_9636;
import org.jspecify.annotations.Nullable;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;

public final class GrindstoneRecipeMaker {
	private static @Nullable class_3803 GRINDSTONE_MENU;

	public static List<IJeiGrindstoneRecipe> getGrindstoneRecipes(IIngredientManager ingredientManager, IPlatformRecipeHelper platformHelper) {
		return Stream.concat(
						getRepairRecipes(platformHelper, ingredientManager),
						getDisenchantRecipes(platformHelper)
				)
				.toList();
	}

	private static Stream<IJeiGrindstoneRecipe> getDisenchantRecipes(IPlatformRecipeHelper platformHelper) {
		class_2378<class_1887> registry = RegistryUtil.getRegistry(class_7924.field_41265);
		List<class_6880.class_6883<class_1887>> enchantments = registry.method_42017().toList();
		List<IJeiGrindstoneRecipe> grindstoneRecipes = new ArrayList<>();
		for (class_6880.class_6883<class_1887> enchantmentHolder : enchantments) {
			if (enchantmentHolder.method_40220(class_9636.field_51551)) {
				continue;
			}
			class_1887 enchantment = enchantmentHolder.comp_349();
			for (class_6880<class_1792> itemHolder : enchantment.method_56109()) {
				class_1799 stack = itemHolder.comp_349().method_7854();
				if (!stack.method_7923() ||
					!platformHelper.isItemEnchantable(stack, enchantmentHolder)
				) {
					continue;
				}
				Optional<class_5321<class_1887>> enchantmentResourceLocation = registry.method_29113(enchantment);
				String enchantmentPath = enchantmentResourceLocation.map(enchantmentResourceKey -> enchantmentResourceKey.method_29177().method_12832()).orElse(null);
				for (int level = 1; level <= Math.min(enchantment.method_8183(), 10); level++) {
					class_1799 enchantedStack = stack.method_7972();
					enchantedStack.method_7978(enchantmentHolder, level);
					String itemId = stack.method_7909().method_7876();
					String asciiLevel = Integer.toString(level);
					String rawPath = "grindstone.disenchantment.%s.%s.%s".formatted(itemId, enchantmentPath, asciiLevel);
					String uidPath = ResourceLocationUtil.sanitizePath(rawPath);
					class_2960 uid = class_2960.method_60656(uidPath);
					IJeiGrindstoneRecipe grindstoneRecipe = getGrindstoneRecipe(platformHelper, enchantedStack, class_1799.field_8037, uid);
					if (grindstoneRecipe != null) {
						grindstoneRecipes.add(grindstoneRecipe);
					}
				}
			}
		}

		return grindstoneRecipes.stream();
	}

	private static Stream<IJeiGrindstoneRecipe> getRepairRecipes(IPlatformRecipeHelper platformHelper, IIngredientManager ingredientManager) {
		return ingredientManager.getAllItemStacks()
				.stream()
				.filter(class_1799::method_7963)
				.mapMulti((stack, consumer) -> {
					stack.method_7974(stack.method_7936() * 3 / 4);
					class_1799 topInput = stack.method_7972();
					class_1799 bottomInput = stack.method_7972();
					String itemId = stack.method_7909().method_7876();
					String rawPath = "grindstone.self_repair." + itemId;
					String uidPath = ResourceLocationUtil.sanitizePath(rawPath);
					IJeiGrindstoneRecipe recipe = getGrindstoneRecipe(platformHelper, topInput, bottomInput, class_2960.method_60656(uidPath));
					if (recipe != null) {
						consumer.accept(recipe);
					}
				});
	}

	@Nullable
	private static IJeiGrindstoneRecipe getGrindstoneRecipe(IPlatformRecipeHelper platformHelper, class_1799 topInput, class_1799 bottomInput, @Nullable class_2960 uid) {
		class_3803 grindstoneMenu = getFakeGrindstoneMenu();
		if (grindstoneMenu == null) {
			return null;
		}
		class_1799 output = platformHelper.getGrindstoneResult(grindstoneMenu, topInput, bottomInput);
		if (output.method_7960()) {
			return null;
		}
		return new GrindstoneRecipe(List.of(topInput), List.of(bottomInput), List.of(output), -1, -1, uid);
	}

	@Nullable
	private static class_3803 getFakeGrindstoneMenu() {
		if (GRINDSTONE_MENU == null) {
			class_1657 player = class_310.method_1551().field_1724;
			if (player == null) {
				return null;
			}
			class_1661 fakeInventory = new class_1661(player, new class_10630());
			GRINDSTONE_MENU = new class_3803(0, fakeInventory);
			return GRINDSTONE_MENU;
		}
		return GRINDSTONE_MENU;
	}
}
