package mezz.jei.library.plugins.vanilla.ingredients;

import com.google.common.collect.Streams;
import mezz.jei.api.constants.Tags;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.helpers.IColorHelper;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.common.Internal;
import mezz.jei.common.config.IClientConfig;
import mezz.jei.common.config.IJeiClientConfigs;
import mezz.jei.common.platform.IPlatformItemStackHelper;
import mezz.jei.common.platform.Services;
import mezz.jei.common.util.ErrorUtil;
import mezz.jei.common.util.RegistryUtil;
import mezz.jei.common.util.StackHelper;
import mezz.jei.common.util.TagUtil;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import org.jspecify.annotations.Nullable;

import java.util.Collection;
import java.util.Optional;
import java.util.stream.Stream;

public class ItemStackHelper implements IIngredientHelper<class_1799> {
	private final StackHelper stackHelper;
	private final IColorHelper colorHelper;
	private final class_6862<class_1792> itemHiddenFromRecipeViewers;
	private final class_6862<class_2248> blockHiddenFromRecipeViewers;

	public ItemStackHelper(StackHelper stackHelper, IColorHelper colorHelper) {
		this.stackHelper = stackHelper;
		this.colorHelper = colorHelper;
		this.itemHiddenFromRecipeViewers = class_6862.method_40092(class_7924.field_41197, Tags.HIDDEN_FROM_RECIPE_VIEWERS);
		this.blockHiddenFromRecipeViewers = class_6862.method_40092(class_7924.field_41254, Tags.HIDDEN_FROM_RECIPE_VIEWERS);
	}

	@Override
	public IIngredientType<class_1799> getIngredientType() {
		return VanillaTypes.ITEM_STACK;
	}

	@Override
	public String getDisplayName(class_1799 ingredient) {
		class_2561 displayNameTextComponent = ingredient.method_7964();
		String displayName = displayNameTextComponent.getString();
		ErrorUtil.checkNotNull(displayName, "itemStack.getDisplayName()");
		return displayName;
	}

	@Override
	public Object getUid(class_1799 ingredient, UidContext context) {
		ErrorUtil.checkNotNull(ingredient, "ingredient");
		ErrorUtil.checkNotNull(context, "type");
		return stackHelper.getUidForStack(ingredient, context);
	}

	@Override
	public Object getUid(ITypedIngredient<class_1799> typedIngredient, UidContext context) {
		ErrorUtil.checkNotNull(typedIngredient, "typedIngredient");
		ErrorUtil.checkNotNull(context, "type");
		return stackHelper.getUidForStack(typedIngredient, context);
	}

	@Override
	public Object getGroupingUid(ITypedIngredient<class_1799> typedIngredient) {
		return typedIngredient.getBaseIngredient(VanillaTypes.ITEM_STACK);
	}

	@Override
	public Object getGroupingUid(class_1799 ingredient) {
		return ingredient.method_7909();
	}

	@Override
	public boolean hasSubtypes(class_1799 ingredient) {
		ErrorUtil.checkNotNull(ingredient, "ingredient");
		return stackHelper.hasSubtypes(ingredient);
	}

	@Override
	public String getDisplayModId(class_1799 ingredient) {
		ErrorUtil.checkNotNull(ingredient, "ingredient");

		IPlatformItemStackHelper itemStackHelper = Services.PLATFORM.getItemStackHelper();
		return itemStackHelper.getCreatorModId(ingredient)
			.or(() -> getNamespace(ingredient))
			.orElseThrow(() -> {
				String stackInfo = getErrorInfo(ingredient);
				return new IllegalStateException("null registryName for: " + stackInfo);
			});
	}

	private static Optional<String> getNamespace(class_1799 ingredient) {
		class_2960 key = RegistryUtil
			.getRegistry(class_7924.field_41197)
			.method_10221(ingredient.method_7909());
		return Optional.ofNullable(key)
			.map(class_2960::method_12836);
	}

	@Override
	public long getAmount(class_1799 ingredient) {
		return ingredient.method_7947();
	}

	@Override
	public class_1799 copyWithAmount(class_1799 ingredient, long amount) {
		class_1799 copy = ingredient.method_7972();
		int intAmount = Math.toIntExact(amount);
		copy.method_7939(intAmount);
		return copy;
	}

	@Override
	public Iterable<Integer> getColors(class_1799 ingredient) {
		return colorHelper.getColors(ingredient, 2);
	}

	@Override
	public class_2960 getIdentifier(class_1799 ingredient) {
		ErrorUtil.checkNotNull(ingredient, "ingredient");

		class_1792 item = ingredient.method_7909();
		class_2960 key = RegistryUtil
			.getRegistry(class_7924.field_41197)
			.method_10221(item);

		if (key == null) {
			String stackInfo = getErrorInfo(ingredient);
			throw new IllegalStateException("item has no key in the Item registry: " + stackInfo);
		}
		return key;
	}

	@Override
	public class_1799 getCheatItemStack(class_1799 ingredient) {
		return ingredient;
	}

	@Override
	public class_1799 copyIngredient(class_1799 ingredient) {
		return ingredient.method_7972();
	}

	@Override
	public class_1799 normalizeIngredient(class_1799 ingredient) {
		if (ingredient.method_7947() == 1) {
			return ingredient;
		}
		// Temporarily setting the count on the original stack this way can "recover" some empty ItemStacks.
		// Copying it first results in the copy being a hard-coded ItemStack#EMPTY that cannot be recovered.
		int originalCount = ingredient.method_7947();
		ingredient.method_7939(1);
		class_1799 copy = ingredient.method_7972();
		ingredient.method_7939(originalCount);
		return copy;
	}

	@Override
	public boolean isValidIngredient(class_1799 ingredient) {
		return !ingredient.method_7960();
	}

	@Override
	public boolean isIngredientOnServer(class_1799 ingredient) {
		class_1792 item = ingredient.method_7909();
		class_2378<class_1792> registry = RegistryUtil.getRegistry(class_7924.field_41197);
		return registry.method_10221(item) != null;
	}

	@Override
	public Stream<class_2960> getTagStream(class_1799 ingredient) {
		Stream<class_2960> itemTagStream = ingredient.method_40133()
			.map(class_6862::comp_327);

		if (ingredient.method_7909() instanceof class_1747 blockItem) {
			IJeiClientConfigs jeiClientConfigs = Internal.getJeiClientConfigs();
			IClientConfig clientConfig = jeiClientConfigs.getClientConfig();
			if (clientConfig.isLookupBlockTagsEnabled()) {
				Stream<class_2960> blockTagStream = blockItem.method_7711()
					.method_9564()
					.method_40144()
					.map(class_6862::comp_327);
				return Streams.concat(itemTagStream, blockTagStream);
			}
		}
		return itemTagStream;
	}

	@Override
	public boolean isHiddenFromRecipeViewersByTags(class_1799 ingredient) {
		return isHiddenFromRecipeViewersByTags(ingredient.method_41409());
	}

	@Override
	public boolean isHiddenFromRecipeViewersByTags(ITypedIngredient<class_1799> ingredient) {
		class_1792 item = ingredient.getBaseIngredient(VanillaTypes.ITEM_STACK);
		@SuppressWarnings("deprecation")
		class_6880.class_6883<class_1792> itemHolder = item.method_40131();
		return isHiddenFromRecipeViewersByTags(itemHolder);
	}

	private boolean isHiddenFromRecipeViewersByTags(class_6880<class_1792> itemHolder) {
		if (itemHolder.method_40220(itemHiddenFromRecipeViewers)) {
			return true;
		}
		if (itemHolder.comp_349() instanceof class_1747 blockItem) {
			IJeiClientConfigs jeiClientConfigs = Internal.getJeiClientConfigs();
			IClientConfig clientConfig = jeiClientConfigs.getClientConfig();
			if (clientConfig.isLookupBlockTagsEnabled()) {
				class_2248 block = blockItem.method_7711();
				@SuppressWarnings("deprecation")
				class_6880.class_6883<class_2248> blockHolder = block.method_40142();
				return blockHolder.method_40220(blockHiddenFromRecipeViewers);
			}
		}
		return false;
	}

	@Override
	public String getErrorInfo(@Nullable class_1799 ingredient) {
		return ErrorUtil.getItemStackInfo(ingredient);
	}

	@Override
	public Optional<class_6862<?>> getTagKeyEquivalent(Collection<class_1799> ingredients) {
		class_2378<class_1792> itemRegistry = RegistryUtil.getRegistry(class_7924.field_41197);
		return TagUtil.getTagEquivalent(ingredients, class_1799::method_7909, itemRegistry::method_40272);
	}
}
