/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.recipes;

import java.util.Set;
import mezz.jei.api.gui.builder.ITooltipBuilder;
import mezz.jei.api.gui.buttons.IButtonState;
import mezz.jei.api.gui.buttons.IIconButtonController;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.inputs.IJeiUserInput;
import mezz.jei.common.Internal;
import mezz.jei.common.config.IClientConfig;
import mezz.jei.common.config.IJeiClientConfigs;
import mezz.jei.common.config.RecipeSorterStage;
import net.minecraft.class_2561;
import net.minecraft.class_5348;

public class RecipeSortStateButtonController
implements IIconButtonController {
    private final IDrawable offIcon;
    private final IDrawable onIcon;
    private final RecipeSorterStage recipeSorterStage;
    private final class_2561 disabledTooltip;
    private final class_2561 enabledTooltip;
    private final Runnable onValueChanged;
    private boolean toggledOn;

    public RecipeSortStateButtonController(RecipeSorterStage recipeSorterStage, IDrawable offIcon, IDrawable onIcon, class_2561 disabledTooltip, class_2561 enabledTooltip, Runnable onValueChanged) {
        this.offIcon = offIcon;
        this.onIcon = onIcon;
        this.recipeSorterStage = recipeSorterStage;
        this.disabledTooltip = disabledTooltip;
        this.enabledTooltip = enabledTooltip;
        this.onValueChanged = onValueChanged;
    }

    @Override
    public void getTooltips(ITooltipBuilder tooltip) {
        if (this.toggledOn) {
            tooltip.add((class_5348)this.enabledTooltip);
        } else {
            tooltip.add((class_5348)this.disabledTooltip);
        }
    }

    @Override
    public void updateState(IButtonState state) {
        IJeiClientConfigs jeiClientConfigs = Internal.getJeiClientConfigs();
        IClientConfig clientConfig = jeiClientConfigs.getClientConfig();
        Set<RecipeSorterStage> recipeSorterStages = clientConfig.getRecipeSorterStages();
        boolean toggledOn = recipeSorterStages.contains((Object)this.recipeSorterStage);
        if (toggledOn != this.toggledOn) {
            this.toggledOn = toggledOn;
            this.onValueChanged.run();
        }
        if (toggledOn) {
            state.setForcePressed(true);
            state.setIcon(this.onIcon);
        } else {
            state.setForcePressed(false);
            state.setIcon(this.offIcon);
        }
    }

    @Override
    public boolean onPress(IJeiUserInput input) {
        if (!input.isSimulate()) {
            IJeiClientConfigs jeiClientConfigs = Internal.getJeiClientConfigs();
            IClientConfig clientConfig = jeiClientConfigs.getClientConfig();
            if (this.toggledOn) {
                clientConfig.disableRecipeSorterStage(this.recipeSorterStage);
                this.toggledOn = false;
            } else {
                clientConfig.enableRecipeSorterStage(this.recipeSorterStage);
                this.toggledOn = true;
            }
            this.onValueChanged.run();
        }
        return true;
    }
}

