package mezz.jei.gui.input.focus;

import mezz.jei.core.util.ReflectionUtil;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_437;
import org.jspecify.annotations.Nullable;

public class ScreenFocusHandler implements IFocusHandler {
	private static final ReflectionUtil reflectionUtil = new ReflectionUtil();

	private final class_437 screen;
	private final @Nullable IFocusHandler focusedElement;
	private final @Nullable class_364 storedInScreenFocus;

	public static @Nullable ScreenFocusHandler create(class_437 screen) {
		class_364 focused = screen.method_25399();
		final IFocusHandler focusedElement;
		final class_364 storedInScreenFocus;
		if (focused != null) {
			focusedElement = GuiEventListenerFocusHandler.create(focused);
			storedInScreenFocus = focused;
		} else {
			class_342 editBox = reflectionUtil.getFieldWithClass(screen, class_342.class)
				.findFirst()
				.orElse(null);
			if (editBox != null) {
				focusedElement = GuiEventListenerFocusHandler.create(editBox);
			} else {
				return null;
			}
			storedInScreenFocus = null;
		}
		return new ScreenFocusHandler(screen, focusedElement, storedInScreenFocus);
	}

	public ScreenFocusHandler(class_437 screen,
							@Nullable IFocusHandler focusedElement,
							@Nullable class_364 storedInScreenFocus
	) {
		this.screen = screen;
		this.focusedElement = focusedElement;
		this.storedInScreenFocus = storedInScreenFocus;
	}

	@Override
	public void unFocus() {
		if (focusedElement != null) {
			focusedElement.unFocus();
			if (storedInScreenFocus != null) {
				screen.method_25395(null);
			}
		}
	}

	@Override
	public void focus() {
		if (focusedElement != null) {
			focusedElement.focus();
			if (storedInScreenFocus != null) {
				screen.method_25395(storedInScreenFocus);
			}
		}
	}
}
