package mezz.jei.library.plugins.vanilla.crafting;

import mezz.jei.api.recipe.category.extensions.vanilla.crafting.ICraftingCategoryExtension;
import net.minecraft.class_10295;
import net.minecraft.class_10300;
import net.minecraft.class_10301;
import net.minecraft.class_10302;
import net.minecraft.class_1869;
import net.minecraft.class_3955;
import net.minecraft.class_8786;
import java.util.List;

public class CraftingCategoryExtension implements ICraftingCategoryExtension<class_3955> {
	@Override
	public int getWidth(class_8786<class_3955> recipeHolder) {
		class_3955 recipe = recipeHolder.comp_1933();
		if (recipe instanceof class_1869 shapedRecipe) {
			return shapedRecipe.method_8150();
		}
		if (recipe instanceof JeiShapedRecipe shapedRecipe) {
			return shapedRecipe.getWidth();
		}
		return 0;
	}

	@Override
	public int getHeight(class_8786<class_3955> recipeHolder) {
		class_3955 recipe = recipeHolder.comp_1933();
		if (recipe instanceof class_1869 shapedRecipe) {
			return shapedRecipe.method_8158();
		}
		if (recipe instanceof JeiShapedRecipe shapedRecipe) {
			return shapedRecipe.getHeight();
		}
		return 0;
	}

	@Override
	public boolean isHandled(class_8786<class_3955> recipeHolder) {
		class_3955 recipe = recipeHolder.comp_1933();
		if (recipe.method_8118()) {
			return false;
		}
		List<class_10295> displays = recipe.method_64664();
		if (displays.isEmpty()) {
			return false;
		}
		class_10295 display = displays.getFirst();
		return display instanceof class_10301 ||
			display instanceof class_10300;
	}

	@Override
	public List<class_10302> getIngredients(class_8786<class_3955> recipeHolder) {
		List<class_10295> displays = recipeHolder.comp_1933().method_64664();
		if (displays.isEmpty()) {
			return List.of();
		}
		class_10295 display = displays.getFirst();
		if (display instanceof class_10300 shapedCraftingRecipeDisplay) {
			return shapedCraftingRecipeDisplay.comp_3270();
		} else if (display instanceof class_10301 shapelessCraftingRecipeDisplay) {
			return shapelessCraftingRecipeDisplay.comp_3271();
		} else {
			return List.of();
		}
	}
}
