package mezz.jei.fabric.platform;

import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.datafixers.util.Either;
import mezz.jei.common.platform.IPlatformRenderHelper;
import net.minecraft.class_1011;
import net.minecraft.class_1047;
import net.minecraft.class_1058;
import net.minecraft.class_1293;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5348;
import net.minecraft.class_5632;
import net.minecraft.class_5684;
import net.minecraft.class_6862;
import net.minecraft.class_773;
import net.minecraft.class_776;
import net.minecraft.class_7764;
import net.minecraft.class_8001;
import net.minecraft.class_8690;
import org.jetbrains.annotations.Nullable;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class RenderHelper implements IPlatformRenderHelper {
	@Override
	public class_327 getFontRenderer(class_310 minecraft, class_1799 itemStack) {
		return minecraft.field_1772;
	}

	@Override
	public boolean shouldRender(class_1293 potionEffect) {
		return true;
	}

	@Override
	@Nullable
	public class_1058 getTextureAtlasSprite(class_2680 blockState) {
		class_310 minecraft = class_310.method_1551();
		class_776 blockRendererDispatcher = minecraft.method_1541();
		class_773 blockModelShapes = blockRendererDispatcher.method_3351();
		class_1058 textureAtlasSprite = blockModelShapes.method_3339(blockState);
		if (textureAtlasSprite.method_45852().equals(class_1047.method_4539())) {
			return null;
		}
		return textureAtlasSprite;
	}

	@Override
	public void blitSprite(class_332 guiGraphics, RenderPipeline renderPipeline, class_1058 sprite, int textureWidth, int textureHeight, int uPosition, int vPosition, int x, int y, int uWidth, int vHeight) {
		guiGraphics.method_52711(renderPipeline, sprite, textureWidth, textureHeight, uPosition, vPosition, x, y, uWidth, vHeight, -1);
	}

	@Override
	public void blitNineSlicedSprite(class_332 guiGraphics, RenderPipeline renderPipeline, class_1058 sprite, class_8690.class_8691 scaling, int xOffset, int yOffset, int width, int height) {
		guiGraphics.method_52713(renderPipeline, sprite, scaling, xOffset, yOffset, width, height, -1);
	}

	@Override
	public void blitTiledSprite(class_332 guiGraphics, RenderPipeline renderPipeline, class_1058 sprite, class_8690.class_8694 scaling, int xOffset, int yOffset, int width, int height, int color) {
		guiGraphics.method_52712(
			renderPipeline,
			sprite,
			xOffset,
			yOffset,
			width,
			height,
			0,
			0,
			scaling.comp_1644(),
			scaling.comp_1645(),
			scaling.comp_1644(),
			scaling.comp_1645(),
			color
		);
	}

	@Override
	public Optional<class_1011> getMainImage(class_1058 sprite) {
		class_7764 contents = sprite.method_45851();
		class_1011[] frames = contents.field_40540;
		if (frames.length == 0) {
			return Optional.empty();
		}
		class_1011 frame = frames[0];
		return Optional.ofNullable(frame);
	}

	@Override
	public void renderTooltip(class_332 guiGraphics, List<Either<class_5348, class_5632>> elements, int x, int y, class_327 font, class_1799 stack) {
		List<class_5684> components = elements.stream()
			.flatMap(e -> e.map(
				text -> font.method_1728(text, 400).stream().map(class_5684::method_32662),
				tooltipComponent -> Stream.of(createClientTooltipComponent(tooltipComponent))
			))
			.collect(Collectors.toCollection(ArrayList::new));

		guiGraphics.method_71273(font, components, x, y, class_8001.field_41687, null, true);
	}

	@Override
	public class_2561 getName(class_6862<?> tagKey) {
		return tagKey.getName();
	}

	private class_5684 createClientTooltipComponent(class_5632 tooltipComponent) {
		if (tooltipComponent instanceof class_5684 clientTooltipComponent) {
			return clientTooltipComponent;
		}
		return class_5684.method_32663(tooltipComponent);
	}
}
