/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.library.helpers;

import com.google.common.collect.ImmutableSetMultimap;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.helpers.IModIdHelper;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.common.platform.IPlatformModHelper;
import mezz.jei.common.platform.Services;
import mezz.jei.library.config.IModIdFormatConfig;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import org.apache.commons.lang3.Strings;

public final class ModIdHelper
implements IModIdHelper {
    private final IModIdFormatConfig modIdFormattingConfig;
    private final IIngredientManager ingredientManager;
    private final ImmutableSetMultimap<String, String> modAliases;

    public ModIdHelper(IModIdFormatConfig modIdFormattingConfig, IIngredientManager ingredientManager, ImmutableSetMultimap<String, String> modAliases) {
        this.modIdFormattingConfig = modIdFormattingConfig;
        this.ingredientManager = ingredientManager;
        this.modAliases = modAliases;
    }

    @Override
    public boolean isDisplayingModNameEnabled() {
        String modNameFormat = this.modIdFormattingConfig.getModNameFormat();
        return !modNameFormat.isEmpty();
    }

    @Override
    public <T> List<class_2561> addModNameToIngredientTooltip(List<class_2561> tooltip, T ingredient, IIngredientHelper<T> ingredientHelper) {
        if (!this.isDisplayingModNameEnabled()) {
            return tooltip;
        }
        if (this.modIdFormattingConfig.isModNameFormatOverrideActive() && ingredient instanceof class_1799) {
            return tooltip;
        }
        String modId = ingredientHelper.getDisplayModId(ingredient);
        String modName = this.getFormattedModNameForModId(modId);
        ArrayList<class_2561> tooltipCopy = new ArrayList<class_2561>(tooltip);
        tooltipCopy.add((class_2561)class_2561.method_43470((String)modName));
        return tooltipCopy;
    }

    @Override
    public <T> Optional<class_2561> getModNameForTooltip(ITypedIngredient<T> typedIngredient) {
        if (!this.isDisplayingModNameEnabled()) {
            return Optional.empty();
        }
        IIngredientType<T> type = typedIngredient.getType();
        if (this.modIdFormattingConfig.isModNameFormatOverrideActive() && type == VanillaTypes.ITEM_STACK) {
            return Optional.empty();
        }
        T ingredient = typedIngredient.getIngredient();
        IIngredientHelper<T> ingredientHelper = this.ingredientManager.getIngredientHelper(type);
        String modId = ingredientHelper.getDisplayModId(ingredient);
        String modName = this.getFormattedModNameForModId(modId);
        return Optional.of(class_2561.method_43470((String)modName));
    }

    @Override
    public <T> List<class_2561> addModNameToIngredientTooltip(List<class_2561> tooltip, ITypedIngredient<T> typedIngredient) {
        IIngredientType<T> type = typedIngredient.getType();
        T ingredient = typedIngredient.getIngredient();
        IIngredientHelper<T> ingredientHelper = this.ingredientManager.getIngredientHelper(type);
        return this.addModNameToIngredientTooltip(tooltip, ingredient, ingredientHelper);
    }

    @Override
    public String getFormattedModNameForModId(String modId) {
        String modName = this.getModNameForModId(modId);
        modName = class_124.method_539((String)modName);
        String modNameFormat = this.modIdFormattingConfig.getModNameFormat();
        if (!modNameFormat.isEmpty()) {
            if (modNameFormat.contains("%MODNAME%")) {
                return Strings.CS.replaceOnce(modNameFormat, "%MODNAME%", modName);
            }
            return modNameFormat + modName;
        }
        return modName;
    }

    @Override
    public Set<String> getModAliases(String modId) {
        return this.modAliases.get((Object)modId);
    }

    @Override
    public String getModNameForModId(String modId) {
        IPlatformModHelper modHelper = Services.PLATFORM.getModHelper();
        return modHelper.getModNameForModId(modId);
    }
}

