/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.library.color;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import mezz.jei.common.platform.IPlatformRenderHelper;
import mezz.jei.common.platform.Services;
import mezz.jei.common.util.ErrorUtil;
import mezz.jei.library.color.ColorThief;
import net.minecraft.class_1011;
import net.minecraft.class_1058;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_324;
import net.minecraft.class_3532;
import net.minecraft.class_7764;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class ColorGetter {
    private static final Logger LOGGER = LogManager.getLogger();

    public List<Integer> getColors(class_1799 itemStack, int colorCount) {
        try {
            return this.unsafeGetColors(itemStack, colorCount);
        }
        catch (LinkageError | RuntimeException e) {
            String itemStackInfo = ErrorUtil.getItemStackInfo(itemStack);
            LOGGER.warn("Failed to get color name for {}", (Object)itemStackInfo, (Object)e);
            return Collections.emptyList();
        }
    }

    private List<Integer> unsafeGetColors(class_1799 itemStack, int colorCount) {
        class_1747 itemBlock;
        class_2248 block;
        class_1792 item = itemStack.method_7909();
        if (!itemStack.method_7960() && item instanceof class_1747 && (block = (itemBlock = (class_1747)item).method_7711()) != null) {
            return this.getBlockColors(block, colorCount);
        }
        return Collections.emptyList();
    }

    private List<Integer> getBlockColors(class_2248 block, int colorCount) {
        class_2680 blockState = block.method_9564();
        class_324 blockColors = class_310.method_1551().method_1505();
        int renderColor = blockColors.method_1697(blockState, null, null, 0);
        IPlatformRenderHelper renderHelper = Services.PLATFORM.getRenderHelper();
        class_1058 textureAtlasSprite = renderHelper.getTextureAtlasSprite(blockState);
        if (textureAtlasSprite == null) {
            return Collections.emptyList();
        }
        return this.getColors(textureAtlasSprite, renderColor, colorCount);
    }

    public List<Integer> getColors(class_1058 textureAtlasSprite, int renderColor, int colorCount) {
        if (colorCount <= 0) {
            return Collections.emptyList();
        }
        return ColorGetter.getNativeImage(textureAtlasSprite).map(bufferedImage -> {
            int[][] palette;
            ArrayList<Integer> colors = new ArrayList<Integer>(colorCount);
            for (int[] colorInt : palette = ColorThief.getPalette(bufferedImage, colorCount, 2, false)) {
                int red = (int)((float)(colorInt[0] - 1) * (float)(renderColor >> 16 & 0xFF) / 255.0f);
                int green = (int)((float)(colorInt[1] - 1) * (float)(renderColor >> 8 & 0xFF) / 255.0f);
                int blue = (int)((float)(colorInt[2] - 1) * (float)(renderColor & 0xFF) / 255.0f);
                red = class_3532.method_15340((int)red, (int)0, (int)255);
                green = class_3532.method_15340((int)green, (int)0, (int)255);
                blue = class_3532.method_15340((int)blue, (int)0, (int)255);
                int color = 0xFF000000 | (red & 0xFF) << 16 | (green & 0xFF) << 8 | blue & 0xFF;
                colors.add(color);
            }
            return colors;
        }).orElseGet(Collections::emptyList);
    }

    private static Optional<class_1011> getNativeImage(class_1058 textureAtlasSprite) {
        class_7764 contents = textureAtlasSprite.method_45851();
        int iconWidth = contents.method_45807();
        int iconHeight = contents.method_45815();
        if (iconWidth <= 0 || iconHeight <= 0) {
            return Optional.empty();
        }
        IPlatformRenderHelper renderHelper = Services.PLATFORM.getRenderHelper();
        return renderHelper.getMainImage(textureAtlasSprite);
    }
}

