/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.fabric.startup;

import java.util.List;
import java.util.stream.Collectors;
import mezz.jei.api.IModPlugin;
import net.fabricmc.loader.api.EntrypointException;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.entrypoint.EntrypointContainer;
import net.fabricmc.loader.api.metadata.ModMetadata;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class FabricPluginFinder {
    private static final Logger LOGGER = LogManager.getLogger();

    private FabricPluginFinder() {
    }

    public static List<IModPlugin> getModPlugins() {
        return FabricPluginFinder.getInstances("jei_mod_plugin", IModPlugin.class);
    }

    private static <T> List<T> getInstances(String entrypointContainerKey, Class<T> instanceClass) {
        FabricLoader fabricLoader = FabricLoader.getInstance();
        List pluginContainers = fabricLoader.getEntrypointContainers(entrypointContainerKey, instanceClass);
        return pluginContainers.stream().mapMulti((entrypointContainer, consumer) -> {
            try {
                Object entrypoint = entrypointContainer.getEntrypoint();
                consumer.accept(entrypoint);
            }
            catch (EntrypointException e) {
                String modName = FabricPluginFinder.getModName(entrypointContainer);
                LOGGER.error("{} specified an invalid entrypoint for its JEI plugin", (Object)modName, (Object)e);
            }
            catch (LinkageError | RuntimeException e) {
                String modName = FabricPluginFinder.getModName(entrypointContainer);
                LOGGER.error("{} specified a broken entrypoint for its JEI plugin", (Object)modName, (Object)e);
            }
        }).collect(Collectors.toList());
    }

    private static String getModName(EntrypointContainer<?> entrypointContainer) {
        try {
            ModContainer provider = entrypointContainer.getProvider();
            ModMetadata metadata = provider.getMetadata();
            return metadata.getName();
        }
        catch (LinkageError | RuntimeException ignored) {
            return "unknown";
        }
    }
}

