package mezz.jei.library.plugins.vanilla.stonecutting;

import com.mojang.serialization.Codec;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.widgets.IRecipeExtrasBuilder;
import mezz.jei.api.helpers.ICodecHelper;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.IRecipeManager;
import mezz.jei.api.recipe.category.AbstractRecipeCategory;
import net.minecraft.class_10295;
import net.minecraft.class_10315;
import net.minecraft.class_2246;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3975;
import net.minecraft.class_8786;

public class StoneCuttingRecipeCategory extends AbstractRecipeCategory<class_8786<class_3975>> {
	public static final int width = 82;
	public static final int height = 34;

	public StoneCuttingRecipeCategory(IGuiHelper guiHelper) {
		super(
			RecipeTypes.STONECUTTING,
			class_2561.method_43471("gui.jei.category.stoneCutter"),
			guiHelper.createDrawableItemLike(class_2246.field_16335),
			width,
			height
		);
	}

	@Override
	public void setRecipe(IRecipeLayoutBuilder builder, class_8786<class_3975> recipeHolder, IFocusGroup focuses) {
		class_3975 recipe = recipeHolder.comp_1933();
		class_10295 display = recipe.method_64664().getFirst();
		if (display instanceof class_10315 stonecutterRecipeDisplay) {
			builder.addInputSlot(1, 9)
				.setStandardSlotBackground()
				.add(stonecutterRecipeDisplay.comp_3305());

			builder.addOutputSlot(61,  9)
				.setOutputSlotBackground()
				.add(stonecutterRecipeDisplay.comp_3258());
		}
	}

	@Override
	public void createRecipeExtras(IRecipeExtrasBuilder builder, class_8786<class_3975> recipe, IFocusGroup focuses) {
		builder.addRecipeArrow().setPosition(26, 9);
	}

	@Override
	public boolean isHandled(class_8786<class_3975> recipeHolder) {
		class_3975 recipe = recipeHolder.comp_1933();
		return !recipe.method_8118();
	}

	@Override
	public class_2960 getIdentifier(class_8786<class_3975> recipe) {
		return recipe.comp_1932().method_29177();
	}

	@Override
	public Codec<class_8786<class_3975>> getCodec(ICodecHelper codecHelper, IRecipeManager recipeManager) {
		return codecHelper.getRecipeHolderCodec();
	}
}
