package mezz.jei.library.plugins.vanilla.brewing;

import mezz.jei.api.recipe.vanilla.IJeiBrewingRecipe;
import mezz.jei.library.plugins.vanilla.ingredients.subtypes.PotionSubtypeInterpreter;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import java.util.List;

public class JeiBrewingRecipe implements IJeiBrewingRecipe {
	private final List<class_1799> ingredients;
	private final List<class_1799> potionInputs;
	private final class_1799 potionOutput;
	private final class_2960 uid;
	private final BrewingRecipeUtil brewingRecipeUtil;

	public JeiBrewingRecipe(
		List<class_1799> ingredients,
		List<class_1799> potionInputs,
		class_1799 potionOutput,
		class_2960 uid,
		BrewingRecipeUtil brewingRecipeUtil
	) {
		this.ingredients = List.copyOf(ingredients);
		this.potionInputs = List.copyOf(potionInputs);
		this.potionOutput = potionOutput;
		this.uid = uid;
		this.brewingRecipeUtil = brewingRecipeUtil;

		brewingRecipeUtil.addRecipe(potionInputs, potionOutput);
	}

	@Override
	public List<class_1799> getPotionInputs() {
		return potionInputs;
	}

	@Override
	public List<class_1799> getIngredients() {
		return ingredients;
	}

	@Override
	public class_1799 getPotionOutput() {
		return potionOutput;
	}

	@Override
	public class_2960 getUid() {
		return uid;
	}

	@Override
	public int getBrewingSteps() {
		return brewingRecipeUtil.getBrewingSteps(potionOutput);
	}

	@Override
	public boolean equals(Object obj) {
		if (!(obj instanceof JeiBrewingRecipe other)) {
			return false;
		}

		return uid.equals(other.uid);
	}

	@Override
	public int hashCode() {
		return uid.hashCode();
	}

	@Override
	public String toString() {
		class_1799 input = potionInputs.getFirst();
		String inputName = PotionSubtypeInterpreter.INSTANCE.getStringName(input);
		String outputName = PotionSubtypeInterpreter.INSTANCE.getStringName(potionOutput);
		return ingredients + " + [" + input.method_7909() + " " + inputName + "] = [" + potionOutput + " " + outputName + "]";
	}
}
