package mezz.jei.library.plugins.debug.ingredients;

import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import net.minecraft.class_124;
import net.minecraft.class_1836;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5250;
import java.util.ArrayList;
import java.util.List;

public class DebugIngredientRenderer implements IIngredientRenderer<DebugIngredient> {
	private final IIngredientHelper<DebugIngredient> ingredientHelper;

	public DebugIngredientRenderer(IIngredientHelper<DebugIngredient> ingredientHelper) {
		this.ingredientHelper = ingredientHelper;
	}

	@Override
	public void render(class_332 guiGraphics, DebugIngredient ingredient) {
		class_310 minecraft = class_310.method_1551();
		class_327 font = getFontRenderer(minecraft, ingredient);
		guiGraphics.method_51433(font, "JEI", 0, 0, 0xFFFF0000, false);
		guiGraphics.method_51433(font, "#" + ingredient.number(), 0, 8, 0xFFFF0000, false);
	}

	@Override
	public List<class_2561> getTooltip(DebugIngredient ingredient, class_1836 tooltipFlag) {
		List<class_2561> tooltip = new ArrayList<>();
		String displayName = ingredientHelper.getDisplayName(ingredient);
		tooltip.add(class_2561.method_43470(displayName));
		class_5250 debugIngredient = class_2561.method_43470("debug ingredient");
		tooltip.add(debugIngredient.method_27692(class_124.field_1080));
		return tooltip;
	}
}
