package mezz.jei.fabric.platform;

import com.mojang.datafixers.util.Either;
import mezz.jei.common.input.MouseButtonEventData;
import mezz.jei.common.input.keys.IJeiKeyMappingCategoryBuilder;
import mezz.jei.common.platform.IPlatformInputHelper;
import mezz.jei.fabric.input.FabricJeiKeyMappingCategoryBuilder;
import net.minecraft.class_11908;
import net.minecraft.class_304;
import net.minecraft.class_3675;

public class InputHelper implements IPlatformInputHelper {
	@Override
	public boolean isActiveAndMatches(class_304 keyMapping, class_3675.class_306 key, Either<MouseButtonEventData, class_11908> event) {
		if (keyMapping.method_1415()) {
			return false;
		}
		return event.map(e -> keyMapping.method_1433(e.event()), keyMapping::method_1417);
	}

	@Override
	public IJeiKeyMappingCategoryBuilder createKeyMappingCategoryBuilder(class_304.class_11900 category) {
		return new FabricJeiKeyMappingCategoryBuilder(category);
	}
}
