package mezz.jei.common.util;

import java.util.Locale;
import java.util.function.Supplier;
import net.minecraft.class_1074;

public final class Translator {
	private static Supplier<Locale> localeSupplier = () -> Locale.ROOT;

	private Translator() {
	}

	public static String translateToLocal(String key) {
		return class_1074.method_4662(key);
	}

	public static String translateToLocalFormatted(String key, Object... format) {
		return class_1074.method_4662(key, format);
	}

	public static String toLowercaseWithLocale(String string) {
		Locale locale = localeSupplier.get();
		return string.toLowerCase(locale);
	}

	public static void setLocaleSupplier(Supplier<Locale> localeSupplier) {
		Translator.localeSupplier = localeSupplier;
	}
}
