package mezz.jei.common.network.packets;

import mezz.jei.api.constants.ModIds;
import mezz.jei.common.config.IServerConfig;
import mezz.jei.common.network.ClientPacketContext;
import mezz.jei.common.network.packets.handlers.ClientCheatPermissionHandler;
import net.minecraft.class_2960;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import java.util.ArrayList;
import java.util.List;

public class PacketCheatPermission extends PlayToClientPacket<PacketCheatPermission> {
	public static final class_9154<PacketCheatPermission> TYPE = new class_9154<>(class_2960.method_60655(ModIds.JEI_ID, "cheat_permission"));
	public static final class_9139<class_9129, PacketCheatPermission> STREAM_CODEC = class_9139.method_56435(
		class_9135.field_48547,
		p -> p.hasPermission,
		class_9135.field_48554.method_56433(class_9135.method_56363()),
		p -> p.allowedCheatingMethods,
		PacketCheatPermission::new
	);

	private final boolean hasPermission;
	private final List<String> allowedCheatingMethods;

	public PacketCheatPermission(boolean hasPermission, IServerConfig serverConfig) {
		this(hasPermission, getAllowedCheatingMethods(serverConfig));
	}

	public PacketCheatPermission(boolean hasPermission, List<String> allowedCheatingMethods) {
		this.hasPermission = hasPermission;
		this.allowedCheatingMethods = allowedCheatingMethods;
	}

	@Override
	public class_9154<PacketCheatPermission> method_56479() {
		return TYPE;
	}

	@Override
	public class_9139<class_9129, PacketCheatPermission> streamCodec() {
		return STREAM_CODEC;
	}

	@Override
	public void process(ClientPacketContext context) {
		ClientCheatPermissionHandler.handleHasCheatPermission(context, hasPermission, allowedCheatingMethods);
	}

	private static List<String> getAllowedCheatingMethods(IServerConfig serverConfig) {
		List<String> allowedCheatingMethods = new ArrayList<>();
		if (serverConfig.isCheatModeEnabledForOp()) {
			allowedCheatingMethods.add("jei.chat.error.no.cheat.permission.op");
		}
		if (serverConfig.isCheatModeEnabledForCreative()) {
			allowedCheatingMethods.add("jei.chat.error.no.cheat.permission.creative");
		}
		if (serverConfig.isCheatModeEnabledForGive()) {
			allowedCheatingMethods.add("jei.chat.error.no.cheat.permission.give");
		}
		return allowedCheatingMethods;
	}
}
