/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.common.gui.elements;

import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import mezz.jei.api.gui.drawable.IScalableDrawable;
import mezz.jei.common.gui.textures.JeiAtlasManager;
import mezz.jei.common.platform.IPlatformRenderHelper;
import mezz.jei.common.platform.Services;
import mezz.jei.common.util.ImmutableRect2i;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.metadata.gui.GuiMetadataSection;
import net.minecraft.client.resources.metadata.gui.GuiSpriteScaling;
import net.minecraft.resources.Identifier;

public class ScalableDrawable
implements IScalableDrawable {
    private final JeiAtlasManager atlasManager;
    private final Identifier spriteId;

    public ScalableDrawable(JeiAtlasManager atlasManager, Identifier spriteId) {
        this.atlasManager = atlasManager;
        this.spriteId = spriteId;
    }

    public void draw(GuiGraphics guiGraphics, ImmutableRect2i area) {
        this.draw(guiGraphics, area.getX(), area.getY(), area.getWidth(), area.getHeight());
    }

    public void draw(GuiGraphics guiGraphics, int xOffset, int yOffset, int width, int height) {
        GuiSpriteScaling scaling;
        TextureAtlasSprite sprite = this.atlasManager.getAtlas().getSprite(this.spriteId);
        GuiSpriteScaling guiSpriteScaling = scaling = sprite.contents().getAdditionalMetadata(GuiMetadataSection.TYPE).orElse(GuiMetadataSection.DEFAULT).scaling();
        Objects.requireNonNull(guiSpriteScaling);
        GuiSpriteScaling guiSpriteScaling2 = guiSpriteScaling;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{GuiSpriteScaling.Tile.class, GuiSpriteScaling.NineSlice.class}, (Object)guiSpriteScaling2, n)) {
            case 0: {
                GuiSpriteScaling.Tile tileScaling = (GuiSpriteScaling.Tile)guiSpriteScaling2;
                IPlatformRenderHelper renderHelper = Services.PLATFORM.getRenderHelper();
                renderHelper.blitTiledSprite(guiGraphics, RenderPipelines.GUI_TEXTURED, sprite, tileScaling, xOffset, yOffset, width, height, -1);
                break;
            }
            case 1: {
                GuiSpriteScaling.NineSlice nineSliceScaling = (GuiSpriteScaling.NineSlice)guiSpriteScaling2;
                IPlatformRenderHelper renderHelper = Services.PLATFORM.getRenderHelper();
                renderHelper.blitNineSlicedSprite(guiGraphics, RenderPipelines.GUI_TEXTURED, sprite, nineSliceScaling, xOffset, yOffset, width, height);
                break;
            }
            default: {
                guiGraphics.blitSprite(RenderPipelines.GUI_TEXTURED, sprite, xOffset, yOffset, width, height);
            }
        }
    }
}

