package mezz.jei.api.gui.handlers;

import mezz.jei.api.registration.IGuiHandlerRegistration;
import net.minecraft.class_437;
import net.minecraft.class_465;
import org.jspecify.annotations.Nullable;

import java.util.function.Function;

/**
 * Creates {@link IGuiProperties} from a {@link class_437} so JEI can draw next to it.
 * By default, JEI already handles this for all {@link class_465}.
 * Register a {@link IScreenHandler} with JEI by using {@link IGuiHandlerRegistration#addGuiScreenHandler(Class, IScreenHandler)}
 */
@FunctionalInterface
public interface IScreenHandler<T extends class_437> extends Function<T, IGuiProperties> {
	@Override
	@Nullable
	IGuiProperties apply(T guiScreen);
}
