package mezz.jei.api.recipe.types;

import com.google.common.base.Suppliers;
import java.util.function.Supplier;
import net.minecraft.class_1860;
import net.minecraft.class_2960;
import net.minecraft.class_3956;
import net.minecraft.class_7923;
import net.minecraft.class_8786;

/**
 * Convenience type that makes it easier to work with {@link IRecipeType} created with vanilla's {@link class_8786}.
 *
 * Create instances with {@link IRecipeHolderType#create}
 *
 * @since 20.0.0
 */
public interface IRecipeHolderType<T extends class_1860<?>> extends IRecipeType<class_8786<T>> {
	/**
	 * Create a JEI RecipeType from a Vanilla RecipeType.
	 * Returns a RecipeType that uses {@link class_8786} to hold recipes.
	 * @since 20.0.0
	 */
	static <R extends class_1860<?>> IRecipeHolderType<R> create(class_3956<R> vanillaRecipeType) {
		return new JeiRecipeHolderType<>(vanillaRecipeType);
	}

	/**
	 * Create a JEI RecipeType from a Identifier.
	 * Returns a RecipeType that uses {@link class_8786} to hold recipes.
	 * @since 20.0.0
	 */
	static <R extends class_1860<?>> IRecipeHolderType<R> create(class_2960 recipeId) {
		return new JeiRecipeHolderType<>(recipeId);
	}

	/**
	 * Create a JEI RecipeType from a deferred Vanilla RecipeType.
	 * Returns a Supplier for a RecipeType that uses {@link class_8786} to hold recipes.
	 * @since 20.0.0
	 */
	static <R extends class_1860<?>> Supplier<IRecipeHolderType<R>> createDeferred(Supplier<class_3956<R>> vanillaRecipeType) {
		return Suppliers.memoize(() -> create(vanillaRecipeType.get()));
	}

	record JeiRecipeHolderType<T extends class_1860<?>>(class_2960 uid) implements IRecipeHolderType<T> {
		private static class_2960 getUid(class_3956<?> recipeType) {
			class_2960 uid = class_7923.field_41188.method_10221(recipeType);
			if (uid == null) {
				throw new IllegalArgumentException("Vanilla Recipe Type must be registered before using it here. %s".formatted(recipeType));
			}
			return uid;
		}

		JeiRecipeHolderType(class_3956<T> vanillaRecipeType) {
			this(getUid(vanillaRecipeType));
		}

		@Override
		public class_2960 getUid() {
			return uid;
		}

		@Override
		public Class<? extends class_8786<T>> getRecipeClass() {
			@SuppressWarnings({"unchecked", "RedundantCast"})
			Class<? extends class_8786<T>> castClass = (Class<? extends class_8786<T>>) (Object) class_8786.class;
			return castClass;
		}
	}
}
