/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.library.plugins.vanilla.brewing;

import java.util.List;
import mezz.jei.api.recipe.vanilla.IJeiBrewingRecipe;
import mezz.jei.library.plugins.vanilla.brewing.BrewingRecipeUtil;
import mezz.jei.library.plugins.vanilla.ingredients.subtypes.PotionSubtypeInterpreter;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public class JeiBrewingRecipe
implements IJeiBrewingRecipe {
    private final List<ItemStack> ingredients;
    private final List<ItemStack> potionInputs;
    private final ItemStack potionOutput;
    private final ResourceLocation uid;
    private final BrewingRecipeUtil brewingRecipeUtil;

    public JeiBrewingRecipe(List<ItemStack> ingredients, List<ItemStack> potionInputs, ItemStack potionOutput, ResourceLocation uid, BrewingRecipeUtil brewingRecipeUtil) {
        this.ingredients = List.copyOf(ingredients);
        this.potionInputs = List.copyOf(potionInputs);
        this.potionOutput = potionOutput;
        this.uid = uid;
        this.brewingRecipeUtil = brewingRecipeUtil;
        brewingRecipeUtil.addRecipe(potionInputs, potionOutput);
    }

    @Override
    public List<ItemStack> getPotionInputs() {
        return this.potionInputs;
    }

    @Override
    public List<ItemStack> getIngredients() {
        return this.ingredients;
    }

    @Override
    public ItemStack getPotionOutput() {
        return this.potionOutput;
    }

    @Override
    public ResourceLocation getUid() {
        return this.uid;
    }

    @Override
    public int getBrewingSteps() {
        return this.brewingRecipeUtil.getBrewingSteps(this.potionOutput);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof JeiBrewingRecipe)) {
            return false;
        }
        JeiBrewingRecipe other = (JeiBrewingRecipe)obj;
        return this.uid.equals((Object)other.uid);
    }

    public int hashCode() {
        return this.uid.hashCode();
    }

    public String toString() {
        ItemStack input = this.potionInputs.getFirst();
        String inputName = PotionSubtypeInterpreter.INSTANCE.getStringName(input);
        String outputName = PotionSubtypeInterpreter.INSTANCE.getStringName(this.potionOutput);
        return String.valueOf(this.ingredients) + " + [" + String.valueOf(input.getItem()) + " " + inputName + "] = [" + String.valueOf(this.potionOutput) + " " + outputName + "]";
    }
}

